/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.properties;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.INullableTypeComputer;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import edu.uci.ics.hyracks.algebricks.core.algebra.typing.ITypeEnvPointer;
import java.util.List;

public abstract class TypePropagationPolicy {
    public static final TypePropagationPolicy ALL = new TypePropagationPolicy(){

        @Override
        public Object getVarType(LogicalVariable var, INullableTypeComputer ntc, List<LogicalVariable> nonNullVariableList, ITypeEnvPointer ... typeEnvs) throws AlgebricksException {
            for (ITypeEnvPointer p : typeEnvs) {
                IVariableTypeEnvironment env = p.getTypeEnv();
                if (env == null) {
                    throw new AlgebricksException("Null environment for pointer " + p + " in getVarType for var=" + var);
                }
                Object t = env.getVarType(var, nonNullVariableList);
                if (t == null) continue;
                return t;
            }
            return null;
        }
    };
    public static final TypePropagationPolicy LEFT_OUTER = new TypePropagationPolicy(){

        @Override
        public Object getVarType(LogicalVariable var, INullableTypeComputer ntc, List<LogicalVariable> nonNullVariableList, ITypeEnvPointer ... typeEnvs) throws AlgebricksException {
            int n = typeEnvs.length;
            for (int i = 0; i < n; ++i) {
                Object t = typeEnvs[i].getTypeEnv().getVarType(var, nonNullVariableList);
                if (t == null) continue;
                if (i == 0) {
                    return t;
                }
                boolean nonNullVarIsProduced = false;
                for (LogicalVariable v : nonNullVariableList) {
                    if (v == var) {
                        nonNullVarIsProduced = true;
                        break;
                    }
                    if (typeEnvs[i].getTypeEnv().getVarType(v) == null) continue;
                    nonNullVarIsProduced = true;
                    break;
                }
                if (nonNullVarIsProduced) {
                    return t;
                }
                return ntc.makeNullableType(t);
            }
            return null;
        }
    };

    public abstract Object getVarType(LogicalVariable var1, INullableTypeComputer var2, List<LogicalVariable> var3, ITypeEnvPointer ... var4) throws AlgebricksException;
}

