/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.properties;

import edu.uci.ics.hyracks.algebricks.common.utils.ListSet;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.EquivalenceClass;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.INodeDomain;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.LocalGroupingProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.OrderColumn;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.OrderedPartitionedProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.UnorderedPartitionedProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class PropertiesUtil {
    public Set<LogicalVariable> closureUnderFDs(Collection<LogicalVariable> vars, List<FunctionalDependency> fdList) {
        boolean change;
        ListSet k = new ListSet(vars);
        do {
            change = false;
            for (FunctionalDependency fd : fdList) {
                List<LogicalVariable> h = fd.getHead();
                if (!k.containsAll(h)) continue;
                List<LogicalVariable> t = fd.getTail();
                for (LogicalVariable v : t) {
                    if (k.contains(v)) continue;
                    k.add(v);
                    change = true;
                }
            }
        } while (change);
        return k;
    }

    public static boolean matchLocalProperties(List<ILocalStructuralProperty> reqd, List<ILocalStructuralProperty> dlvd, Map<LogicalVariable, EquivalenceClass> equivalenceClasses, List<FunctionalDependency> fds) {
        if (reqd == null) {
            return true;
        }
        if (dlvd == null) {
            return false;
        }
        PropertiesUtil.normalizeLocals(reqd, equivalenceClasses, fds);
        PropertiesUtil.normalizeLocals(dlvd, equivalenceClasses, fds);
        ListIterator<ILocalStructuralProperty> dlvdIter = dlvd.listIterator();
        ListSet rqdCols = new ListSet();
        ListSet dlvdCols = new ListSet();
        for (ILocalStructuralProperty r : reqd) {
            if (r.getPropertyType() == ILocalStructuralProperty.PropertyType.LOCAL_GROUPING_PROPERTY) {
                rqdCols.clear();
                r.getVariables((Collection<LogicalVariable>)rqdCols);
            }
            boolean implied = false;
            block5: while (!implied && dlvdIter.hasNext()) {
                ILocalStructuralProperty d = dlvdIter.next();
                switch (r.getPropertyType()) {
                    case LOCAL_ORDER_PROPERTY: {
                        if (d.getPropertyType() != ILocalStructuralProperty.PropertyType.LOCAL_ORDER_PROPERTY) {
                            return false;
                        }
                        LocalOrderProperty lop = (LocalOrderProperty)d;
                        if (lop.getColumn() == ((LocalOrderProperty)r).getColumn() && lop.getOrder() == ((LocalOrderProperty)r).getOrder()) {
                            implied = true;
                            continue block5;
                        }
                        return false;
                    }
                    case LOCAL_GROUPING_PROPERTY: {
                        dlvdCols.clear();
                        d.getColumns((Collection<LogicalVariable>)dlvdCols);
                        for (LogicalVariable v : dlvdCols) {
                            if (rqdCols.contains(v)) {
                                rqdCols.remove(v);
                                continue;
                            }
                            return false;
                        }
                        if (!rqdCols.isEmpty()) continue block5;
                        implied = true;
                        continue block5;
                    }
                }
                throw new IllegalStateException();
            }
            if (implied) continue;
            return false;
        }
        return true;
    }

    public static boolean matchPartitioningProps(IPartitioningProperty reqd, IPartitioningProperty dlvd, boolean mayExpandProperties) {
        INodeDomain dom1 = reqd.getNodeDomain();
        INodeDomain dom2 = dlvd.getNodeDomain();
        if (dom1 != null && dom2 != null && !dom1.sameAs(dom2)) {
            return false;
        }
        switch (reqd.getPartitioningType()) {
            case RANDOM: {
                return true;
            }
            case UNORDERED_PARTITIONED: {
                switch (dlvd.getPartitioningType()) {
                    case UNORDERED_PARTITIONED: {
                        UnorderedPartitionedProperty ur = (UnorderedPartitionedProperty)reqd;
                        UnorderedPartitionedProperty ud = (UnorderedPartitionedProperty)dlvd;
                        if (mayExpandProperties) {
                            return ur.getColumnSet().containsAll(ud.getColumnSet());
                        }
                        return ur.getColumnSet().equals(ud.getColumnSet());
                    }
                    case ORDERED_PARTITIONED: {
                        UnorderedPartitionedProperty ur = (UnorderedPartitionedProperty)reqd;
                        OrderedPartitionedProperty od = (OrderedPartitionedProperty)dlvd;
                        if (mayExpandProperties) {
                            return ur.getColumnSet().containsAll(od.getOrderColumns());
                        }
                        return ur.getColumnSet().containsAll(od.getOrderColumns()) && od.getOrderColumns().containsAll(ur.getColumnSet());
                    }
                }
                return false;
            }
            case ORDERED_PARTITIONED: {
                switch (dlvd.getPartitioningType()) {
                    case ORDERED_PARTITIONED: {
                        OrderedPartitionedProperty or = (OrderedPartitionedProperty)reqd;
                        OrderedPartitionedProperty od = (OrderedPartitionedProperty)dlvd;
                        if (mayExpandProperties) {
                            return PropertiesUtil.isPrefixOf(od.getOrderColumns(), or.getOrderColumns());
                        }
                        return od.getOrderColumns().equals(or.getOrderColumns());
                    }
                }
                return false;
            }
        }
        return dlvd.getPartitioningType() == reqd.getPartitioningType();
    }

    private static boolean isPrefixOf(List<OrderColumn> pref, List<OrderColumn> target) {
        Iterator<OrderColumn> iter = target.iterator();
        for (OrderColumn v : pref) {
            if (!iter.hasNext()) {
                return false;
            }
            if (v.equals(iter.next())) continue;
            return false;
        }
        return true;
    }

    public static ArrayList<OrderColumn> applyFDsToOrderColumns(ArrayList<OrderColumn> orderColumns, List<FunctionalDependency> fds) {
        if (fds == null || fds.isEmpty()) {
            return orderColumns;
        }
        int deleted = 0;
        block0: for (int i = orderColumns.size() - 1; i >= 0; --i) {
            for (FunctionalDependency fdep : fds) {
                if (!PropertiesUtil.impliedByPrefix(orderColumns, i, fdep)) continue;
                orderColumns.set(i, null);
                ++deleted;
                continue block0;
            }
        }
        ArrayList<OrderColumn> norm = new ArrayList<OrderColumn>(orderColumns.size() - deleted);
        for (OrderColumn oc : orderColumns) {
            if (oc == null) continue;
            norm.add(oc);
        }
        return norm;
    }

    public static ArrayList<OrderColumn> replaceOrderColumnsByEqClasses(ArrayList<OrderColumn> orderColumns, Map<LogicalVariable, EquivalenceClass> equivalenceClasses) {
        if (equivalenceClasses == null || equivalenceClasses.isEmpty()) {
            return orderColumns;
        }
        ArrayList<OrderColumn> norm = new ArrayList<OrderColumn>();
        for (OrderColumn v : orderColumns) {
            EquivalenceClass ec = equivalenceClasses.get(v.getColumn());
            if (ec == null) {
                norm.add(v);
                continue;
            }
            if (ec.representativeIsConst()) continue;
            norm.add(new OrderColumn(ec.getVariableRepresentative(), v.getOrder()));
        }
        return norm;
    }

    private static boolean impliedByPrefix(ArrayList<OrderColumn> vars, int i, FunctionalDependency fdep) {
        if (!fdep.getTail().contains(vars.get(i).getColumn())) {
            return false;
        }
        boolean fdSat = true;
        for (LogicalVariable pv : fdep.getHead()) {
            boolean isInPrefix = false;
            for (int j = 0; j < i; ++j) {
                if (!vars.get(j).getColumn().equals(pv)) continue;
                isInPrefix = true;
                break;
            }
            if (isInPrefix) continue;
            fdSat = false;
            break;
        }
        return fdSat;
    }

    private static void normalizeLocals(List<ILocalStructuralProperty> props, Map<LogicalVariable, EquivalenceClass> equivalenceClasses, List<FunctionalDependency> fds) {
        ILocalStructuralProperty p;
        ListIterator<ILocalStructuralProperty> propIter = props.listIterator();
        int pos = -1;
        while (propIter.hasNext()) {
            p = propIter.next();
            if (p.getPropertyType() == ILocalStructuralProperty.PropertyType.LOCAL_GROUPING_PROPERTY) {
                ((LocalGroupingProperty)p).normalizeGroupingColumns(equivalenceClasses, fds);
                ++pos;
                continue;
            }
            LocalOrderProperty ord = (LocalOrderProperty)p;
            EquivalenceClass ec = equivalenceClasses.get(ord.getColumn());
            if (ec != null) {
                if (ec.representativeIsConst()) {
                    propIter.remove();
                    continue;
                }
                ord.getOrderColumn().setColumn(ec.getVariableRepresentative());
                ++pos;
                continue;
            }
            ++pos;
        }
        if (pos < 1) {
            return;
        }
        block1: while (propIter.hasPrevious()) {
            p = propIter.previous();
            ListIterator<ILocalStructuralProperty> secondIter = props.listIterator(pos);
            --pos;
            ListSet cols = new ListSet();
            while (secondIter.hasPrevious()) {
                secondIter.previous().getColumns((Collection<LogicalVariable>)cols);
            }
            secondIter = null;
            for (FunctionalDependency fdep : fds) {
                LinkedList<LogicalVariable> columnsOfP = new LinkedList<LogicalVariable>();
                p.getColumns(columnsOfP);
                if (!PropertiesUtil.impliedByPrefix(columnsOfP, (Set<LogicalVariable>)cols, fdep)) continue;
                propIter.remove();
                continue block1;
            }
        }
    }

    private static boolean impliedByPrefix(List<LogicalVariable> colsOfProp, Set<LogicalVariable> colsOfPrefix, FunctionalDependency fdep) {
        return fdep.getTail().containsAll(colsOfProp) && colsOfPrefix.containsAll(fdep.getHead());
    }
}

