/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.properties;

import edu.uci.ics.hyracks.algebricks.core.algebra.base.EquivalenceClass;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.INodeDomain;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.OrderColumn;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.PropertiesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class OrderedPartitionedProperty
implements IPartitioningProperty {
    private ArrayList<OrderColumn> orderColumns;
    private INodeDomain domain;

    public OrderedPartitionedProperty(ArrayList<OrderColumn> orderColumns, INodeDomain domain) {
        this.domain = domain;
        this.orderColumns = orderColumns;
    }

    public ArrayList<OrderColumn> getOrderColumns() {
        return this.orderColumns;
    }

    public ArrayList<LogicalVariable> getColumns() {
        ArrayList<LogicalVariable> cols = new ArrayList<LogicalVariable>(this.orderColumns.size());
        for (OrderColumn oc : this.orderColumns) {
            cols.add(oc.getColumn());
        }
        return cols;
    }

    @Override
    public IPartitioningProperty.PartitioningType getPartitioningType() {
        return IPartitioningProperty.PartitioningType.ORDERED_PARTITIONED;
    }

    public String toString() {
        return this.getPartitioningType().toString() + this.orderColumns;
    }

    @Override
    public void normalize(Map<LogicalVariable, EquivalenceClass> equivalenceClasses, List<FunctionalDependency> fds) {
        this.orderColumns = PropertiesUtil.replaceOrderColumnsByEqClasses(this.orderColumns, equivalenceClasses);
        this.orderColumns = PropertiesUtil.applyFDsToOrderColumns(this.orderColumns, fds);
    }

    @Override
    public void getColumns(Collection<LogicalVariable> columns) {
        for (OrderColumn oc : this.orderColumns) {
            columns.add(oc.getColumn());
        }
    }

    @Override
    public INodeDomain getNodeDomain() {
        return this.domain;
    }

    @Override
    public void setNodeDomain(INodeDomain domain) {
        this.domain = domain;
    }
}

