/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.properties;

import edu.uci.ics.hyracks.algebricks.core.algebra.properties.INodeDomain;
import edu.uci.ics.hyracks.dataflow.std.file.FileSplit;

public class FileSplitDomain
implements INodeDomain {
    private FileSplit[] splits;

    public FileSplitDomain(FileSplit[] splits) {
        this.splits = splits;
    }

    @Override
    public Integer cardinality() {
        return this.splits.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FileSplitDomain[");
        boolean fst = true;
        for (FileSplit fs : this.splits) {
            if (fst) {
                fst = false;
            } else {
                sb.append(", ");
            }
            sb.append(fs.getNodeName() + ":" + fs.getLocalFile());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public boolean sameAs(INodeDomain domain) {
        if (!(domain instanceof FileSplitDomain)) {
            return false;
        }
        FileSplitDomain fsd = (FileSplitDomain)domain;
        if (fsd.splits.length != this.splits.length) {
            return false;
        }
        for (int i = 0; i < this.splits.length; ++i) {
            if (this.ncEq(this.splits[i], fsd.splits[i])) continue;
            return false;
        }
        return true;
    }

    private boolean ncEq(FileSplit fs1, FileSplit fs2) {
        return fs1.getNodeName().equals(fs2.getNodeName());
    }
}

