/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.properties;

import edu.uci.ics.hyracks.algebricks.common.utils.ListSet;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.EquivalenceClass;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractGroupingProperty {
    protected Set<LogicalVariable> columnSet;

    public AbstractGroupingProperty(Set<LogicalVariable> columnSet) {
        this.columnSet = columnSet;
    }

    public Set<LogicalVariable> getColumnSet() {
        return this.columnSet;
    }

    public final void normalizeGroupingColumns(Map<LogicalVariable, EquivalenceClass> equivalenceClasses, List<FunctionalDependency> fds) {
        this.replaceGroupingColumnsByEqClasses(equivalenceClasses);
        this.applyFDsToGroupingColumns(fds);
    }

    private void replaceGroupingColumnsByEqClasses(Map<LogicalVariable, EquivalenceClass> equivalenceClasses) {
        if (equivalenceClasses == null || equivalenceClasses.isEmpty()) {
            return;
        }
        ListSet norm = new ListSet();
        for (LogicalVariable v : this.columnSet) {
            EquivalenceClass ec = equivalenceClasses.get(v);
            if (ec == null) {
                norm.add(v);
                continue;
            }
            if (ec.representativeIsConst()) continue;
            norm.add(ec.getVariableRepresentative());
        }
        this.columnSet = norm;
    }

    private void applyFDsToGroupingColumns(List<FunctionalDependency> fds) {
        if (fds == null || fds.isEmpty()) {
            return;
        }
        ListSet norm = new ListSet();
        for (LogicalVariable v : this.columnSet) {
            boolean isImpliedByAnFD = false;
            for (FunctionalDependency fdep : fds) {
                if (!this.columnSet.containsAll(fdep.getHead()) || !fdep.getTail().contains(v)) continue;
                isImpliedByAnFD = true;
                norm.addAll(fdep.getHead());
                break;
            }
            if (isImpliedByAnFD) continue;
            norm.add(v);
        }
        this.columnSet = norm;
    }
}

