/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.prettyprint;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import edu.uci.ics.hyracks.algebricks.core.algebra.prettyprint.LogicalOperatorPrettyPrintVisitor;
import org.apache.commons.lang3.mutable.Mutable;

public class PlanPrettyPrinter {
    public static void printPlan(ILogicalPlan plan, StringBuilder out, LogicalOperatorPrettyPrintVisitor pvisitor, int indent) throws AlgebricksException {
        for (Mutable<ILogicalOperator> root : plan.getRoots()) {
            PlanPrettyPrinter.printOperator((AbstractLogicalOperator)root.getValue(), out, pvisitor, indent);
        }
    }

    public static void printPhysicalOps(ILogicalPlan plan, StringBuilder out, int indent) {
        for (Mutable<ILogicalOperator> root : plan.getRoots()) {
            PlanPrettyPrinter.printPhysicalOperator((AbstractLogicalOperator)root.getValue(), indent, out);
        }
    }

    public static void printOperator(AbstractLogicalOperator op, StringBuilder out, LogicalOperatorPrettyPrintVisitor pvisitor, int indent) throws AlgebricksException {
        out.append(op.accept(pvisitor, indent));
        IPhysicalOperator pOp = op.getPhysicalOperator();
        if (pOp != null) {
            out.append("\n");
            PlanPrettyPrinter.pad(out, indent);
            PlanPrettyPrinter.appendln(out, "-- " + pOp.toString() + "  |" + (Object)((Object)op.getExecutionMode()) + "|");
        } else {
            PlanPrettyPrinter.appendln(out, " -- |" + (Object)((Object)op.getExecutionMode()) + "|");
        }
        for (Mutable<ILogicalOperator> i : op.getInputs()) {
            PlanPrettyPrinter.printOperator((AbstractLogicalOperator)i.getValue(), out, pvisitor, indent + 2);
        }
    }

    public static void printPhysicalOperator(AbstractLogicalOperator op, int indent, StringBuilder out) {
        IPhysicalOperator pOp = op.getPhysicalOperator();
        PlanPrettyPrinter.pad(out, indent);
        PlanPrettyPrinter.appendln(out, "-- " + pOp.toString() + "  |" + (Object)((Object)op.getExecutionMode()) + "|");
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans opNest = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : opNest.getNestedPlans()) {
                PlanPrettyPrinter.pad(out, indent + 8);
                PlanPrettyPrinter.appendln(out, "{");
                PlanPrettyPrinter.printPhysicalOps(p, out, indent + 10);
                PlanPrettyPrinter.pad(out, indent + 8);
                PlanPrettyPrinter.appendln(out, "}");
            }
        }
        for (Mutable<ILogicalOperator> i : op.getInputs()) {
            PlanPrettyPrinter.printPhysicalOperator((AbstractLogicalOperator)i.getValue(), indent + 2, out);
        }
    }

    private static void appendln(StringBuilder buf, String s) {
        buf.append(s);
        buf.append("\n");
    }

    private static void pad(StringBuilder buf, int indent) {
        for (int i = 0; i < indent; ++i) {
            buf.append(' ');
        }
    }
}

