/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.prettyprint;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.Pair;
import edu.uci.ics.hyracks.algebricks.common.utils.Triple;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.ExtensionOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.PartitioningSplitOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.prettyprint.LogicalExpressionPrettyPrintVisitor;
import edu.uci.ics.hyracks.algebricks.core.algebra.prettyprint.PlanPrettyPrinter;
import edu.uci.ics.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;
import edu.uci.ics.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;

public class LogicalOperatorPrettyPrintVisitor
implements ILogicalOperatorVisitor<String, Integer> {
    ILogicalExpressionVisitor<String, Integer> exprVisitor;

    public LogicalOperatorPrettyPrintVisitor() {
        this.exprVisitor = new LogicalExpressionPrettyPrintVisitor();
    }

    public LogicalOperatorPrettyPrintVisitor(ILogicalExpressionVisitor<String, Integer> exprVisitor) {
        this.exprVisitor = exprVisitor;
    }

    @Override
    public String visitAggregateOperator(AggregateOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("aggregate ").append(op.getVariables()).append(" <- ");
        this.pprintExprList(op.getExpressions(), buffer, indent);
        return buffer.toString();
    }

    @Override
    public String visitRunningAggregateOperator(RunningAggregateOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("running-aggregate ").append(op.getVariables()).append(" <- ");
        this.pprintExprList(op.getExpressions(), buffer, indent);
        return buffer.toString();
    }

    @Override
    public String visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Integer indent) {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("empty-tuple-source");
        return buffer.toString();
    }

    @Override
    public String visitGroupByOperator(GroupByOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("group by (");
        this.pprintVeList(buffer, op.getGroupByList(), indent);
        buffer.append(") decor (");
        this.pprintVeList(buffer, op.getDecorList(), indent);
        buffer.append(") {");
        this.printNestedPlans(op, indent, buffer);
        return buffer.toString();
    }

    @Override
    public String visitDistinctOperator(DistinctOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("distinct (");
        this.pprintExprList(op.getExpressions(), buffer, indent);
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public String visitInnerJoinOperator(InnerJoinOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("join (").append(((ILogicalExpression)op.getCondition().getValue()).accept(this.exprVisitor, indent)).append(")");
        return buffer.toString();
    }

    @Override
    public String visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("left outer join (").append(((ILogicalExpression)op.getCondition().getValue()).accept(this.exprVisitor, indent)).append(")");
        return buffer.toString();
    }

    @Override
    public String visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Integer indent) {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("nested tuple source");
        return buffer.toString();
    }

    @Override
    public String visitOrderOperator(OrderOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("order ");
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> p : op.getOrderExpressions()) {
            String fst;
            switch (((OrderOperator.IOrder)p.first).getKind()) {
                case ASC: {
                    fst = "ASC";
                    break;
                }
                case DESC: {
                    fst = "DESC";
                    break;
                }
                default: {
                    fst = ((OrderOperator.IOrder)p.first).getExpressionRef().toString();
                }
            }
            buffer.append("(" + fst + ", " + ((ILogicalExpression)((Mutable)p.second).getValue()).accept(this.exprVisitor, indent) + ") ");
        }
        return buffer.toString();
    }

    @Override
    public String visitAssignOperator(AssignOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("assign ").append(op.getVariables()).append(" <- ");
        this.pprintExprList(op.getExpressions(), buffer, indent);
        return buffer.toString();
    }

    @Override
    public String visitWriteOperator(WriteOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("write ");
        this.pprintExprList(op.getExpressions(), buffer, indent);
        return buffer.toString();
    }

    @Override
    public String visitDistributeResultOperator(DistributeResultOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("distribute result ");
        this.pprintExprList(op.getExpressions(), buffer, indent);
        return buffer.toString();
    }

    @Override
    public String visitWriteResultOperator(WriteResultOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("load ").append(op.getDataSource()).append(" from ").append(((ILogicalExpression)op.getPayloadExpression().getValue()).accept(this.exprVisitor, indent)).append(" partitioned by ");
        this.pprintExprList(op.getKeyExpressions(), buffer, indent);
        return buffer.toString();
    }

    @Override
    public String visitSelectOperator(SelectOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("select (").append(((ILogicalExpression)op.getCondition().getValue()).accept(this.exprVisitor, indent)).append(")");
        return buffer.toString();
    }

    @Override
    public String visitProjectOperator(ProjectOperator op, Integer indent) {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("project (" + op.getVariables() + ")");
        return buffer.toString();
    }

    @Override
    public String visitPartitioningSplitOperator(PartitioningSplitOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("partitioning-split (");
        this.pprintExprList(op.getExpressions(), buffer, indent);
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public String visitSubplanOperator(SubplanOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("subplan {");
        this.printNestedPlans(op, indent, buffer);
        return buffer.toString();
    }

    @Override
    public String visitUnionOperator(UnionAllOperator op, Integer indent) {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("union");
        for (Triple<LogicalVariable, LogicalVariable, LogicalVariable> v : op.getVariableMappings()) {
            buffer.append(" (" + v.first + ", " + v.second + ", " + v.third + ")");
        }
        return buffer.toString();
    }

    @Override
    public String visitUnnestOperator(UnnestOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("unnest " + op.getVariable());
        if (op.getPositionalVariable() != null) {
            buffer.append(" at " + op.getPositionalVariable());
        }
        buffer.append(" <- " + ((ILogicalExpression)op.getExpressionRef().getValue()).accept(this.exprVisitor, indent));
        return buffer.toString();
    }

    @Override
    public String visitUnnestMapOperator(UnnestMapOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("unnest-map " + op.getVariables() + " <- " + ((ILogicalExpression)op.getExpressionRef().getValue()).accept(this.exprVisitor, indent));
        return buffer.toString();
    }

    @Override
    public String visitDataScanOperator(DataSourceScanOperator op, Integer indent) {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("data-scan " + op.getProjectVariables() + "<-" + op.getVariables() + " <- " + op.getDataSource());
        return buffer.toString();
    }

    @Override
    public String visitLimitOperator(LimitOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("limit " + ((ILogicalExpression)op.getMaxObjects().getValue()).accept(this.exprVisitor, indent));
        ILogicalExpression offset = (ILogicalExpression)op.getOffset().getValue();
        if (offset != null) {
            buffer.append(", " + offset.accept(this.exprVisitor, indent));
        }
        return buffer.toString();
    }

    @Override
    public String visitExchangeOperator(ExchangeOperator op, Integer indent) {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("exchange ");
        return buffer.toString();
    }

    @Override
    public String visitScriptOperator(ScriptOperator op, Integer indent) {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("script (in: " + op.getInputVariables() + ") (out: " + op.getOutputVariables() + ")");
        return buffer.toString();
    }

    @Override
    public String visitReplicateOperator(ReplicateOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("replicate ");
        return buffer.toString();
    }

    @Override
    public String visitInsertDeleteOperator(InsertDeleteOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        String header = op.getOperation() == InsertDeleteOperator.Kind.INSERT ? "insert into " : "delete from ";
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append(header).append(op.getDataSource()).append(" from ").append(((ILogicalExpression)op.getPayloadExpression().getValue()).accept(this.exprVisitor, indent)).append(" partitioned by ");
        this.pprintExprList(op.getPrimaryKeyExpressions(), buffer, indent);
        return buffer.toString();
    }

    @Override
    public String visitIndexInsertDeleteOperator(IndexInsertDeleteOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        String header = op.getOperation() == InsertDeleteOperator.Kind.INSERT ? "insert into " : "delete from ";
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append(header).append(op.getDataSourceIndex()).append(" from ");
        this.pprintExprList(op.getSecondaryKeyExpressions(), buffer, indent);
        buffer.append(" ");
        this.pprintExprList(op.getPrimaryKeyExpressions(), buffer, indent);
        return buffer.toString();
    }

    @Override
    public String visitSinkOperator(SinkOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("sink");
        return buffer.toString();
    }

    @Override
    public String visitExtensionOperator(ExtensionOperator op, Integer indent) throws AlgebricksException {
        StringBuilder buffer = new StringBuilder();
        LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append(op.toString());
        return buffer.toString();
    }

    protected static final StringBuilder addIndent(StringBuilder buffer, int level) {
        for (int i = 0; i < level; ++i) {
            buffer.append(' ');
        }
        return buffer;
    }

    protected void printNestedPlans(AbstractOperatorWithNestedPlans op, Integer indent, StringBuilder buffer) throws AlgebricksException {
        boolean first = true;
        if (op.getNestedPlans().isEmpty()) {
            buffer.append("}");
        } else {
            for (ILogicalPlan p : op.getNestedPlans()) {
                buffer.append("\n");
                if (first) {
                    first = false;
                } else {
                    LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("       {\n");
                }
                PlanPrettyPrinter.printPlan(p, buffer, this, indent + 10);
                LogicalOperatorPrettyPrintVisitor.addIndent(buffer, indent).append("       }");
            }
        }
    }

    protected void pprintExprList(List<Mutable<ILogicalExpression>> expressions, StringBuilder buffer, Integer indent) throws AlgebricksException {
        buffer.append("[");
        boolean first = true;
        for (Mutable<ILogicalExpression> exprRef : expressions) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(((ILogicalExpression)exprRef.getValue()).accept(this.exprVisitor, indent));
        }
        buffer.append("]");
    }

    protected void pprintVeList(StringBuilder sb, List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> vePairList, Integer indent) throws AlgebricksException {
        sb.append("[");
        boolean fst = true;
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> ve : vePairList) {
            if (fst) {
                fst = false;
            } else {
                sb.append("; ");
            }
            if (ve.first != null) {
                sb.append(ve.first + " := " + ve.second);
                continue;
            }
            sb.append(((ILogicalExpression)((Mutable)ve.second).getValue()).accept(this.exprVisitor, indent));
        }
        sb.append("]");
    }
}

