/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.Pair;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.AbstractExchangePOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.OrderColumn;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import edu.uci.ics.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import edu.uci.ics.hyracks.algebricks.data.IBinaryComparatorFactoryProvider;
import edu.uci.ics.hyracks.algebricks.data.IBinaryHashFunctionFactoryProvider;
import edu.uci.ics.hyracks.algebricks.data.INormalizedKeyComputerFactoryProvider;
import edu.uci.ics.hyracks.api.dataflow.IConnectorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryHashFunctionFactory;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputerFactory;
import edu.uci.ics.hyracks.api.job.IConnectorDescriptorRegistry;
import edu.uci.ics.hyracks.dataflow.common.data.partition.FieldHashPartitionComputerFactory;
import edu.uci.ics.hyracks.dataflow.std.connectors.MToNPartitioningMergingConnectorDescriptor;
import java.util.ArrayList;

public class SortMergeExchangePOperator
extends AbstractExchangePOperator {
    private OrderColumn[] sortColumns;

    public SortMergeExchangePOperator(OrderColumn[] sortColumns) {
        this.sortColumns = sortColumns;
    }

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.SORT_MERGE_EXCHANGE;
    }

    public OrderColumn[] getSortColumns() {
        return this.sortColumns;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOperatorTag());
        sb.append(" [");
        sb.append(this.sortColumns[0]);
        for (int i = 1; i < this.sortColumns.length; ++i) {
            sb.append(", " + this.sortColumns[i]);
        }
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator inp1 = (AbstractLogicalOperator)op.getInputs().get(0).getValue();
        IPhysicalPropertiesVector pv1 = inp1.getDeliveredPhysicalProperties();
        if (pv1 == null) {
            inp1.computeDeliveredPhysicalProperties(context);
            pv1 = inp1.getDeliveredPhysicalProperties();
        }
        int sortCol = 0;
        ArrayList<ILocalStructuralProperty> localProps = new ArrayList<ILocalStructuralProperty>(this.sortColumns.length);
        for (ILocalStructuralProperty prop : pv1.getLocalProperties()) {
            if (prop.getPropertyType() != ILocalStructuralProperty.PropertyType.LOCAL_ORDER_PROPERTY) break;
            LocalOrderProperty lop = (LocalOrderProperty)prop;
            if (!lop.getOrderColumn().equals(this.sortColumns[sortCol])) continue;
            localProps.add(lop);
            if (++sortCol != this.sortColumns.length) continue;
            break;
        }
        if (sortCol < this.sortColumns.length) {
            localProps = null;
        }
        this.deliveredProperties = new StructuralPropertiesVector(IPartitioningProperty.UNPARTITIONED, localProps);
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent) {
        ArrayList<ILocalStructuralProperty> localProps = new ArrayList<ILocalStructuralProperty>(this.sortColumns.length);
        for (OrderColumn oc : this.sortColumns) {
            localProps.add(new LocalOrderProperty(oc));
        }
        IPhysicalPropertiesVector[] r = new StructuralPropertiesVector[]{new StructuralPropertiesVector(null, localProps)};
        return new PhysicalRequirements(r, IPartitioningRequirementsCoordinator.NO_COORDINATION);
    }

    @Override
    public Pair<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint> createConnectorDescriptor(IConnectorDescriptorRegistry spec, ILogicalOperator op, IOperatorSchema opSchema, JobGenContext context) throws AlgebricksException {
        int n = this.sortColumns.length;
        int[] sortFields = new int[n];
        IBinaryComparatorFactory[] comps = new IBinaryComparatorFactory[n];
        IBinaryHashFunctionFactory[] hashFuns = new IBinaryHashFunctionFactory[n];
        IVariableTypeEnvironment env = context.getTypeEnvironment(op);
        INormalizedKeyComputerFactoryProvider nkcfProvider = context.getNormalizedKeyComputerFactoryProvider();
        INormalizedKeyComputerFactory nkcf = null;
        for (int i = 0; i < n; ++i) {
            sortFields[i] = opSchema.findVariable(this.sortColumns[i].getColumn());
            Object type = env.getVarType(this.sortColumns[i].getColumn());
            IBinaryComparatorFactoryProvider bcfp = context.getBinaryComparatorFactoryProvider();
            comps[i] = bcfp.getBinaryComparatorFactory(type, this.sortColumns[i].getOrder() == OrderOperator.IOrder.OrderKind.ASC);
            IBinaryHashFunctionFactoryProvider bhffp = context.getBinaryHashFunctionFactoryProvider();
            hashFuns[i] = bhffp.getBinaryHashFunctionFactory(type);
            if (i != 0 || nkcfProvider == null || type == null) continue;
            nkcf = nkcfProvider.getNormalizedKeyComputerFactory(type, this.sortColumns[i].getOrder() == OrderOperator.IOrder.OrderKind.ASC);
        }
        FieldHashPartitionComputerFactory tpcf = new FieldHashPartitionComputerFactory(sortFields, hashFuns);
        MToNPartitioningMergingConnectorDescriptor conn = new MToNPartitioningMergingConnectorDescriptor(spec, (ITuplePartitionComputerFactory)tpcf, sortFields, comps, nkcf);
        return new Pair((Object)conn, (Object)IHyracksJobBuilder.TargetConstraint.ONE);
    }
}

