/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.exceptions.NotImplementedException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IExpressionRuntimeProvider;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.AbstractJoinPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.BroadcastPartitioningProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import edu.uci.ics.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import edu.uci.ics.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import edu.uci.ics.hyracks.algebricks.data.IBinaryBooleanInspector;
import edu.uci.ics.hyracks.algebricks.data.IBinaryBooleanInspectorFactory;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.IOperatorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.value.INullWriterFactory;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePairComparator;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePairComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.api.job.JobSpecification;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.VoidPointable;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import edu.uci.ics.hyracks.dataflow.std.join.NestedLoopJoinOperatorDescriptor;
import java.util.LinkedList;

public class NLJoinPOperator
extends AbstractJoinPOperator {
    private final int memSize;

    public NLJoinPOperator(AbstractBinaryJoinOperator.JoinKind kind, AbstractJoinPOperator.JoinPartitioningType partitioningType, int memSize) {
        super(kind, partitioningType);
        this.memSize = memSize;
    }

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.NESTED_LOOP;
    }

    @Override
    public boolean isMicroOperator() {
        return false;
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator iop, IOptimizationContext context) {
        AbstractLogicalOperator op2;
        IPhysicalPropertiesVector pv1;
        if (this.partitioningType != AbstractJoinPOperator.JoinPartitioningType.BROADCAST) {
            throw new NotImplementedException((Object)((Object)this.partitioningType) + " nested loop joins are not implemented.");
        }
        AbstractLogicalOperator op = (AbstractLogicalOperator)iop;
        Object pp = op.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.PARTITIONED ? ((pv1 = (op2 = (AbstractLogicalOperator)op.getInputs().get(1).getValue()).getPhysicalOperator().getDeliveredProperties()) == null ? null : pv1.getPartitioningProperty()) : IPartitioningProperty.UNPARTITIONED;
        LinkedList<ILocalStructuralProperty> localProps = new LinkedList<ILocalStructuralProperty>();
        this.deliveredProperties = new StructuralPropertiesVector((IPartitioningProperty)pp, localProps);
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent) {
        if (this.partitioningType != AbstractJoinPOperator.JoinPartitioningType.BROADCAST) {
            throw new NotImplementedException((Object)((Object)this.partitioningType) + " nested loop joins are not implemented.");
        }
        IPhysicalPropertiesVector[] pv = new StructuralPropertiesVector[]{new StructuralPropertiesVector(new BroadcastPartitioningProperty(null), null), new StructuralPropertiesVector(null, null)};
        return new PhysicalRequirements(pv, IPartitioningRequirementsCoordinator.NO_COORDINATION);
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        AbstractBinaryJoinOperator join = (AbstractBinaryJoinOperator)op;
        RecordDescriptor recDescriptor = JobGenHelper.mkRecordDescriptor(context.getTypeEnvironment(op), propagatedSchema, context);
        IOperatorSchema[] conditionInputSchemas = new IOperatorSchema[]{propagatedSchema};
        IExpressionRuntimeProvider expressionRuntimeProvider = context.getExpressionRuntimeProvider();
        IScalarEvaluatorFactory cond = expressionRuntimeProvider.createEvaluatorFactory((ILogicalExpression)join.getCondition().getValue(), context.getTypeEnvironment(op), conditionInputSchemas, context);
        TuplePairEvaluatorFactory comparatorFactory = new TuplePairEvaluatorFactory(cond, context.getBinaryBooleanInspectorFactory());
        JobSpecification spec = builder.getJobSpec();
        NestedLoopJoinOperatorDescriptor opDesc = null;
        switch (this.kind) {
            case INNER: {
                opDesc = new NestedLoopJoinOperatorDescriptor((IOperatorDescriptorRegistry)spec, (ITuplePairComparatorFactory)comparatorFactory, recDescriptor, this.memSize, false, null);
                break;
            }
            case LEFT_OUTER: {
                INullWriterFactory[] nullWriterFactories = new INullWriterFactory[inputSchemas[1].getSize()];
                for (int j = 0; j < nullWriterFactories.length; ++j) {
                    nullWriterFactories[j] = context.getNullWriterFactory();
                }
                opDesc = new NestedLoopJoinOperatorDescriptor((IOperatorDescriptorRegistry)spec, (ITuplePairComparatorFactory)comparatorFactory, recDescriptor, this.memSize, true, nullWriterFactories);
                break;
            }
            default: {
                throw new NotImplementedException();
            }
        }
        this.contributeOpDesc(builder, (AbstractLogicalOperator)op, (IOperatorDescriptor)opDesc);
        ILogicalOperator src1 = (ILogicalOperator)op.getInputs().get(0).getValue();
        builder.contributeGraphEdge(src1, 0, op, 0);
        ILogicalOperator src2 = (ILogicalOperator)op.getInputs().get(1).getValue();
        builder.contributeGraphEdge(src2, 0, op, 1);
    }

    public static class CompositeFrameTupleReference
    implements IFrameTupleReference {
        private final FrameTupleReference refLeft;
        private final FrameTupleReference refRight;

        public CompositeFrameTupleReference(FrameTupleReference refLeft, FrameTupleReference refRight) {
            this.refLeft = refLeft;
            this.refRight = refRight;
        }

        public void reset(IFrameTupleAccessor outerAccessor, int outerIndex, IFrameTupleAccessor innerAccessor, int innerIndex) {
            this.refLeft.reset(outerAccessor, outerIndex);
            this.refRight.reset(innerAccessor, innerIndex);
        }

        public int getFieldCount() {
            return this.refLeft.getFieldCount() + this.refRight.getFieldCount();
        }

        public byte[] getFieldData(int fIdx) {
            int leftFieldCount = this.refLeft.getFieldCount();
            if (fIdx < leftFieldCount) {
                return this.refLeft.getFieldData(fIdx);
            }
            return this.refRight.getFieldData(fIdx - leftFieldCount);
        }

        public int getFieldStart(int fIdx) {
            int leftFieldCount = this.refLeft.getFieldCount();
            if (fIdx < leftFieldCount) {
                return this.refLeft.getFieldStart(fIdx);
            }
            return this.refRight.getFieldStart(fIdx - leftFieldCount);
        }

        public int getFieldLength(int fIdx) {
            int leftFieldCount = this.refLeft.getFieldCount();
            if (fIdx < leftFieldCount) {
                return this.refLeft.getFieldLength(fIdx);
            }
            return this.refRight.getFieldLength(fIdx - leftFieldCount);
        }

        public IFrameTupleAccessor getFrameTupleAccessor() {
            throw new NotImplementedException();
        }

        public int getTupleIndex() {
            throw new NotImplementedException();
        }
    }

    public static class TuplePairEvaluator
    implements ITuplePairComparator {
        private final IHyracksTaskContext ctx;
        private IScalarEvaluator condEvaluator;
        private final IScalarEvaluatorFactory condFactory;
        private final IPointable p;
        private final CompositeFrameTupleReference compositeTupleRef;
        private final FrameTupleReference leftRef;
        private final FrameTupleReference rightRef;
        private final IBinaryBooleanInspector binaryBooleanInspector;

        public TuplePairEvaluator(IHyracksTaskContext ctx, IScalarEvaluatorFactory condFactory, IBinaryBooleanInspector binaryBooleanInspector) {
            this.ctx = ctx;
            this.condFactory = condFactory;
            this.binaryBooleanInspector = binaryBooleanInspector;
            this.leftRef = new FrameTupleReference();
            this.p = VoidPointable.FACTORY.createPointable();
            this.rightRef = new FrameTupleReference();
            this.compositeTupleRef = new CompositeFrameTupleReference(this.leftRef, this.rightRef);
        }

        public int compare(IFrameTupleAccessor outerAccessor, int outerIndex, IFrameTupleAccessor innerAccessor, int innerIndex) throws HyracksDataException {
            if (this.condEvaluator == null) {
                try {
                    this.condEvaluator = this.condFactory.createScalarEvaluator(this.ctx);
                }
                catch (AlgebricksException ae) {
                    throw new HyracksDataException((Throwable)ae);
                }
            }
            this.compositeTupleRef.reset(outerAccessor, outerIndex, innerAccessor, innerIndex);
            try {
                this.condEvaluator.evaluate((IFrameTupleReference)this.compositeTupleRef, this.p);
            }
            catch (AlgebricksException ae) {
                throw new HyracksDataException((Throwable)ae);
            }
            boolean result = this.binaryBooleanInspector.getBooleanValue(this.p.getByteArray(), this.p.getStartOffset(), this.p.getLength());
            if (result) {
                return 0;
            }
            return 1;
        }
    }

    public static class TuplePairEvaluatorFactory
    implements ITuplePairComparatorFactory {
        private static final long serialVersionUID = 1L;
        private final IScalarEvaluatorFactory cond;
        private final IBinaryBooleanInspectorFactory binaryBooleanInspectorFactory;

        public TuplePairEvaluatorFactory(IScalarEvaluatorFactory cond, IBinaryBooleanInspectorFactory binaryBooleanInspectorFactory) {
            this.cond = cond;
            this.binaryBooleanInspectorFactory = binaryBooleanInspectorFactory;
        }

        public synchronized ITuplePairComparator createTuplePairComparator(IHyracksTaskContext ctx) {
            return new TuplePairEvaluator(ctx, this.cond, this.binaryBooleanInspectorFactory.createBinaryBooleanInspector(ctx));
        }
    }
}

