/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.exceptions.NotImplementedException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.AbstractHashJoinPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.AbstractJoinPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.JoinMultiComparatorFactory;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import edu.uci.ics.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import edu.uci.ics.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import edu.uci.ics.hyracks.algebricks.data.IBinaryComparatorFactoryProvider;
import edu.uci.ics.hyracks.api.dataflow.IOperatorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryHashFunctionFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryHashFunctionFamily;
import edu.uci.ics.hyracks.api.dataflow.value.INullWriterFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IPredicateEvaluatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IPredicateEvaluatorFactoryProvider;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePairComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.job.IOperatorDescriptorRegistry;
import edu.uci.ics.hyracks.api.job.JobSpecification;
import edu.uci.ics.hyracks.dataflow.std.join.HybridHashJoinOperatorDescriptor;
import edu.uci.ics.hyracks.dataflow.std.join.OptimizedHybridHashJoinOperatorDescriptor;
import java.util.LinkedList;
import java.util.List;

public class HybridHashJoinPOperator
extends AbstractHashJoinPOperator {
    private final int memSizeInFrames;
    private final int maxInputBuildSizeInFrames;
    private final int aveRecordsPerFrame;
    private final double fudgeFactor;

    public HybridHashJoinPOperator(AbstractBinaryJoinOperator.JoinKind kind, AbstractJoinPOperator.JoinPartitioningType partitioningType, List<LogicalVariable> sideLeftOfEqualities, List<LogicalVariable> sideRightOfEqualities, int memSizeInFrames, int maxInputSize0InFrames, int aveRecordsPerFrame, double fudgeFactor) {
        super(kind, partitioningType, sideLeftOfEqualities, sideRightOfEqualities);
        this.memSizeInFrames = memSizeInFrames;
        this.maxInputBuildSizeInFrames = maxInputSize0InFrames;
        this.aveRecordsPerFrame = aveRecordsPerFrame;
        this.fudgeFactor = fudgeFactor;
    }

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.HYBRID_HASH_JOIN;
    }

    @Override
    public boolean isMicroOperator() {
        return false;
    }

    public double getFudgeFactor() {
        return this.fudgeFactor;
    }

    public int getMemSizeInFrames() {
        return this.memSizeInFrames;
    }

    @Override
    public String toString() {
        return this.getOperatorTag().toString() + " " + this.keysLeftBranch + this.keysRightBranch;
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        int j;
        INullWriterFactory[] nullWriterFactories;
        int[] keysLeft = JobGenHelper.variablesToFieldIndexes(this.keysLeftBranch, inputSchemas[0]);
        int[] keysRight = JobGenHelper.variablesToFieldIndexes(this.keysRightBranch, inputSchemas[1]);
        IVariableTypeEnvironment env = context.getTypeEnvironment(op);
        IBinaryHashFunctionFactory[] hashFunFactories = JobGenHelper.variablesToBinaryHashFunctionFactories(this.keysLeftBranch, env, context);
        IBinaryHashFunctionFamily[] hashFunFamilies = JobGenHelper.variablesToBinaryHashFunctionFamilies(this.keysLeftBranch, env, context);
        IBinaryComparatorFactory[] comparatorFactories = new IBinaryComparatorFactory[keysLeft.length];
        int i = 0;
        IBinaryComparatorFactoryProvider bcfp = context.getBinaryComparatorFactoryProvider();
        for (LogicalVariable v : this.keysLeftBranch) {
            Object t = env.getVarType(v);
            comparatorFactories[i++] = bcfp.getBinaryComparatorFactory(t, true);
        }
        IPredicateEvaluatorFactoryProvider predEvaluatorFactoryProvider = context.getPredicateEvaluatorFactoryProvider();
        IPredicateEvaluatorFactory predEvaluatorFactory = predEvaluatorFactoryProvider == null ? null : predEvaluatorFactoryProvider.getPredicateEvaluatorFactory(keysLeft, keysRight);
        RecordDescriptor recDescriptor = JobGenHelper.mkRecordDescriptor(context.getTypeEnvironment(op), propagatedSchema, context);
        JobSpecification spec = builder.getJobSpec();
        HybridHashJoinOperatorDescriptor opDesc = null;
        boolean optimizedHashJoin = true;
        for (IBinaryHashFunctionFamily family : hashFunFamilies) {
            if (family != null) continue;
            optimizedHashJoin = false;
            break;
        }
        if (!optimizedHashJoin) {
            try {
                switch (this.kind) {
                    case INNER: {
                        opDesc = new HybridHashJoinOperatorDescriptor((IOperatorDescriptorRegistry)spec, this.getMemSizeInFrames(), this.maxInputBuildSizeInFrames, this.aveRecordsPerFrame, this.getFudgeFactor(), keysLeft, keysRight, hashFunFactories, comparatorFactories, recDescriptor, predEvaluatorFactory);
                        break;
                    }
                    case LEFT_OUTER: {
                        nullWriterFactories = new INullWriterFactory[inputSchemas[1].getSize()];
                        for (j = 0; j < nullWriterFactories.length; ++j) {
                            nullWriterFactories[j] = context.getNullWriterFactory();
                        }
                        opDesc = new HybridHashJoinOperatorDescriptor((IOperatorDescriptorRegistry)spec, this.getMemSizeInFrames(), this.maxInputBuildSizeInFrames, this.aveRecordsPerFrame, this.getFudgeFactor(), keysLeft, keysRight, hashFunFactories, comparatorFactories, recDescriptor, predEvaluatorFactory, true, nullWriterFactories);
                        break;
                    }
                    default: {
                        throw new NotImplementedException();
                    }
                }
            }
            catch (HyracksDataException e) {
                throw new AlgebricksException((Throwable)e);
            }
        }
        try {
            switch (this.kind) {
                case INNER: {
                    opDesc = new OptimizedHybridHashJoinOperatorDescriptor((IOperatorDescriptorRegistry)spec, this.getMemSizeInFrames(), this.maxInputBuildSizeInFrames, this.getFudgeFactor(), keysLeft, keysRight, hashFunFamilies, comparatorFactories, recDescriptor, (ITuplePairComparatorFactory)new JoinMultiComparatorFactory(comparatorFactories, keysLeft, keysRight), (ITuplePairComparatorFactory)new JoinMultiComparatorFactory(comparatorFactories, keysRight, keysLeft), predEvaluatorFactory);
                    break;
                }
                case LEFT_OUTER: {
                    nullWriterFactories = new INullWriterFactory[inputSchemas[1].getSize()];
                    for (j = 0; j < nullWriterFactories.length; ++j) {
                        nullWriterFactories[j] = context.getNullWriterFactory();
                    }
                    opDesc = new OptimizedHybridHashJoinOperatorDescriptor((IOperatorDescriptorRegistry)spec, this.getMemSizeInFrames(), this.maxInputBuildSizeInFrames, this.getFudgeFactor(), keysLeft, keysRight, hashFunFamilies, comparatorFactories, recDescriptor, (ITuplePairComparatorFactory)new JoinMultiComparatorFactory(comparatorFactories, keysLeft, keysRight), (ITuplePairComparatorFactory)new JoinMultiComparatorFactory(comparatorFactories, keysRight, keysLeft), predEvaluatorFactory, true, nullWriterFactories);
                    break;
                }
                default: {
                    throw new NotImplementedException();
                }
            }
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
        this.contributeOpDesc(builder, (AbstractLogicalOperator)op, (IOperatorDescriptor)opDesc);
        ILogicalOperator src1 = (ILogicalOperator)op.getInputs().get(0).getValue();
        builder.contributeGraphEdge(src1, 0, op, 0);
        ILogicalOperator src2 = (ILogicalOperator)op.getInputs().get(1).getValue();
        builder.contributeGraphEdge(src2, 0, op, 1);
    }

    @Override
    protected List<ILocalStructuralProperty> deliveredLocalProperties(ILogicalOperator op, IOptimizationContext context) throws AlgebricksException {
        return new LinkedList<ILocalStructuralProperty>();
    }
}

