/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.ListSet;
import edu.uci.ics.hyracks.algebricks.common.utils.Pair;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.AbstractExchangePOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.INodeDomain;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.OrderColumn;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.UnorderedPartitionedProperty;
import edu.uci.ics.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import edu.uci.ics.hyracks.algebricks.data.IBinaryComparatorFactoryProvider;
import edu.uci.ics.hyracks.algebricks.data.IBinaryHashFunctionFactoryProvider;
import edu.uci.ics.hyracks.algebricks.data.INormalizedKeyComputerFactoryProvider;
import edu.uci.ics.hyracks.api.dataflow.IConnectorDescriptor;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.dataflow.value.IBinaryHashFunctionFactory;
import edu.uci.ics.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import edu.uci.ics.hyracks.api.dataflow.value.ITuplePartitionComputerFactory;
import edu.uci.ics.hyracks.api.job.IConnectorDescriptorRegistry;
import edu.uci.ics.hyracks.dataflow.common.data.partition.FieldHashPartitionComputerFactory;
import edu.uci.ics.hyracks.dataflow.std.connectors.MToNPartitioningMergingConnectorDescriptor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class HashPartitionMergeExchangePOperator
extends AbstractExchangePOperator {
    private List<OrderColumn> orderColumns;
    private List<LogicalVariable> partitionFields;
    private INodeDomain domain;

    public HashPartitionMergeExchangePOperator(List<OrderColumn> orderColumns, List<LogicalVariable> partitionFields, INodeDomain domain) {
        this.orderColumns = orderColumns;
        this.partitionFields = partitionFields;
        this.domain = domain;
    }

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.HASH_PARTITION_MERGE_EXCHANGE;
    }

    public List<OrderColumn> getOrderExpressions() {
        return this.orderColumns;
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        UnorderedPartitionedProperty p = new UnorderedPartitionedProperty((Set<LogicalVariable>)new ListSet(this.partitionFields), this.domain);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)op.getInputs().get(0).getValue();
        List<ILocalStructuralProperty> op2Locals = op2.getDeliveredPhysicalProperties().getLocalProperties();
        ArrayList<ILocalStructuralProperty> locals = new ArrayList<ILocalStructuralProperty>();
        for (ILocalStructuralProperty prop : op2Locals) {
            if (prop.getPropertyType() != ILocalStructuralProperty.PropertyType.LOCAL_ORDER_PROPERTY) break;
            locals.add(prop);
        }
        this.deliveredProperties = new StructuralPropertiesVector(p, locals);
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent) {
        LinkedList<ILocalStructuralProperty> orderProps = new LinkedList<ILocalStructuralProperty>();
        block4: for (OrderColumn oc : this.orderColumns) {
            LogicalVariable var = oc.getColumn();
            switch (oc.getOrder()) {
                case ASC: {
                    orderProps.add(new LocalOrderProperty(new OrderColumn(var, OrderOperator.IOrder.OrderKind.ASC)));
                    continue block4;
                }
                case DESC: {
                    orderProps.add(new LocalOrderProperty(new OrderColumn(var, OrderOperator.IOrder.OrderKind.DESC)));
                    continue block4;
                }
            }
            throw new IllegalStateException();
        }
        IPhysicalPropertiesVector[] r = new StructuralPropertiesVector[]{new StructuralPropertiesVector(null, orderProps)};
        return new PhysicalRequirements(r, IPartitioningRequirementsCoordinator.NO_COORDINATION);
    }

    @Override
    public String toString() {
        return this.getOperatorTag().toString() + " MERGE:" + this.orderColumns + " HASH:" + this.partitionFields;
    }

    @Override
    public Pair<IConnectorDescriptor, IHyracksJobBuilder.TargetConstraint> createConnectorDescriptor(IConnectorDescriptorRegistry spec, ILogicalOperator op, IOperatorSchema opSchema, JobGenContext context) throws AlgebricksException {
        int[] keys = new int[this.partitionFields.size()];
        IBinaryHashFunctionFactory[] hashFunctionFactories = new IBinaryHashFunctionFactory[this.partitionFields.size()];
        IVariableTypeEnvironment env = context.getTypeEnvironment(op);
        int i = 0;
        IBinaryHashFunctionFactoryProvider hashFunProvider = context.getBinaryHashFunctionFactoryProvider();
        for (LogicalVariable v : this.partitionFields) {
            keys[i] = opSchema.findVariable(v);
            hashFunctionFactories[i] = hashFunProvider.getBinaryHashFunctionFactory(env.getVarType(v));
            ++i;
        }
        FieldHashPartitionComputerFactory tpcf = new FieldHashPartitionComputerFactory(keys, hashFunctionFactories);
        int n = this.orderColumns.size();
        int[] sortFields = new int[n];
        IBinaryComparatorFactory[] comparatorFactories = new IBinaryComparatorFactory[n];
        INormalizedKeyComputerFactoryProvider nkcfProvider = context.getNormalizedKeyComputerFactoryProvider();
        INormalizedKeyComputerFactory nkcf = null;
        int j = 0;
        for (OrderColumn oc : this.orderColumns) {
            LogicalVariable var = oc.getColumn();
            sortFields[j] = opSchema.findVariable(var);
            Object type = env.getVarType(var);
            IBinaryComparatorFactoryProvider bcfp = context.getBinaryComparatorFactoryProvider();
            comparatorFactories[j] = bcfp.getBinaryComparatorFactory(type, oc.getOrder() == OrderOperator.IOrder.OrderKind.ASC);
            if (j == 0 && nkcfProvider != null && type != null) {
                nkcf = nkcfProvider.getNormalizedKeyComputerFactory(type, oc.getOrder() == OrderOperator.IOrder.OrderKind.ASC);
            }
            ++j;
        }
        MToNPartitioningMergingConnectorDescriptor conn = new MToNPartitioningMergingConnectorDescriptor(spec, (ITuplePartitionComputerFactory)tpcf, sortFields, comparatorFactories, nkcf);
        return new Pair((Object)conn, null);
    }

    public List<LogicalVariable> getPartitionFields() {
        return this.partitionFields;
    }

    public List<OrderColumn> getOrderColumns() {
        return this.orderColumns;
    }
}

