/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical;

import edu.uci.ics.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.Pair;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import edu.uci.ics.hyracks.algebricks.core.algebra.metadata.IDataSource;
import edu.uci.ics.hyracks.algebricks.core.algebra.metadata.IDataSourcePropertiesProvider;
import edu.uci.ics.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.AbstractScanPOperator;
import edu.uci.ics.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import edu.uci.ics.hyracks.api.dataflow.IOperatorDescriptor;
import java.util.List;

public class DataSourceScanPOperator
extends AbstractScanPOperator {
    private IDataSource<?> dataSource;
    private Object implConfig;

    public DataSourceScanPOperator(IDataSource<?> dataSource) {
        this.dataSource = dataSource;
    }

    public void setImplConfig(Object implConfig) {
        this.implConfig = implConfig;
    }

    public Object getImplConfig() {
        return this.implConfig;
    }

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.DATASOURCE_SCAN;
    }

    @Override
    public boolean isMicroOperator() {
        return false;
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        DataSourceScanOperator dssOp = (DataSourceScanOperator)op;
        IDataSourcePropertiesProvider dspp = this.dataSource.getPropertiesProvider();
        this.deliveredProperties = dspp.computePropertiesVector(dssOp.getVariables());
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema opSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        DataSourceScanOperator scan = (DataSourceScanOperator)op;
        IMetadataProvider<?, ?> mp = context.getMetadataProvider();
        IVariableTypeEnvironment typeEnv = context.getTypeEnvironment(op);
        List<LogicalVariable> vars = scan.getVariables();
        List<LogicalVariable> projectVars = scan.getProjectVariables();
        Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> p = mp.getScannerRuntime(this.dataSource, vars, projectVars, scan.isProjectPushed(), opSchema, typeEnv, context, builder.getJobSpec(), this.implConfig);
        builder.contributeHyracksOperator(scan, (IOperatorDescriptor)p.first);
        if (p.second != null) {
            builder.contributeAlgebricksPartitionConstraint((IOperatorDescriptor)p.first, (AlgebricksPartitionConstraint)p.second);
        }
        ILogicalOperator srcExchange = (ILogicalOperator)scan.getInputs().get(0).getValue();
        builder.contributeGraphEdge(srcExchange, 0, scan, 0);
    }
}

