/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical;

import edu.uci.ics.hyracks.algebricks.common.exceptions.NotImplementedException;
import edu.uci.ics.hyracks.algebricks.common.utils.Pair;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.AbstractPhysicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.OrderColumn;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;

public abstract class AbstractStableSortPOperator
extends AbstractPhysicalOperator {
    protected OrderColumn[] sortColumns;
    protected List<ILocalStructuralProperty> orderProps;

    public OrderColumn[] getSortColumns() {
        return this.sortColumns;
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        this.computeLocalProperties(op);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)op.getInputs().get(0).getValue();
        StructuralPropertiesVector childProp = (StructuralPropertiesVector)op2.getDeliveredPhysicalProperties();
        this.deliveredProperties = new StructuralPropertiesVector(childProp.getPartitioningProperty(), this.orderProps);
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator iop, IPhysicalPropertiesVector reqdByParent) {
        AbstractLogicalOperator op = (AbstractLogicalOperator)iop;
        if (op.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.PARTITIONED) {
            if (this.orderProps == null) {
                this.computeLocalProperties(op);
            }
            IPhysicalPropertiesVector[] r = new StructuralPropertiesVector[]{new StructuralPropertiesVector(IPartitioningProperty.UNPARTITIONED, this.orderProps)};
            return new PhysicalRequirements(r, IPartitioningRequirementsCoordinator.NO_COORDINATION);
        }
        return this.emptyUnaryRequirements();
    }

    public void computeLocalProperties(ILogicalOperator op) {
        this.orderProps = new LinkedList<ILocalStructuralProperty>();
        OrderOperator ord = (OrderOperator)op;
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> p : ord.getOrderExpressions()) {
            ILogicalExpression expr = (ILogicalExpression)((Mutable)p.second).getValue();
            if (expr.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
                VariableReferenceExpression varRef = (VariableReferenceExpression)expr;
                LogicalVariable var = varRef.getVariableReference();
                switch (((OrderOperator.IOrder)p.first).getKind()) {
                    case ASC: {
                        this.orderProps.add(new LocalOrderProperty(new OrderColumn(var, OrderOperator.IOrder.OrderKind.ASC)));
                        break;
                    }
                    case DESC: {
                        this.orderProps.add(new LocalOrderProperty(new OrderColumn(var, OrderOperator.IOrder.OrderKind.DESC)));
                        break;
                    }
                    default: {
                        throw new NotImplementedException();
                    }
                }
                continue;
            }
            throw new IllegalStateException();
        }
        int n = this.orderProps.size();
        this.sortColumns = new OrderColumn[n];
        int i = 0;
        for (ILocalStructuralProperty prop : this.orderProps) {
            this.sortColumns[i++] = ((LocalOrderProperty)prop).getOrderColumn();
        }
    }

    public List<ILocalStructuralProperty> getOrderProperties() {
        return this.orderProps;
    }

    @Override
    public String toString() {
        if (this.orderProps == null) {
            return this.getOperatorTag().toString();
        }
        return this.getOperatorTag().toString() + " " + this.orderProps;
    }
}

