/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.Pair;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.ProducedVariableVisitor;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.SchemaVariableVisitor;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.SubstituteVariableVisitor;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.UsedVariableVisitor;
import edu.uci.ics.hyracks.algebricks.core.algebra.typing.ITypingContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;

public class VariableUtilities {
    public static void getUsedVariables(ILogicalOperator op, Collection<LogicalVariable> usedVariables) throws AlgebricksException {
        UsedVariableVisitor visitor = new UsedVariableVisitor(usedVariables);
        op.accept(visitor, null);
    }

    public static void getProducedVariables(ILogicalOperator op, Collection<LogicalVariable> producedVariables) throws AlgebricksException {
        ProducedVariableVisitor visitor = new ProducedVariableVisitor(producedVariables);
        op.accept(visitor, null);
    }

    public static void getLiveVariables(ILogicalOperator op, Collection<LogicalVariable> schemaVariables) throws AlgebricksException {
        SchemaVariableVisitor visitor = new SchemaVariableVisitor(schemaVariables);
        op.accept(visitor, null);
    }

    public static void getUsedVariablesInDescendantsAndSelf(ILogicalOperator op, Collection<LogicalVariable> vars) throws AlgebricksException {
        VariableUtilities.getUsedVariables(op, vars);
        for (Mutable<ILogicalOperator> c : op.getInputs()) {
            VariableUtilities.getUsedVariablesInDescendantsAndSelf((ILogicalOperator)c.getValue(), vars);
        }
    }

    public static void substituteVariables(ILogicalOperator op, LogicalVariable v1, LogicalVariable v2, ITypingContext ctx) throws AlgebricksException {
        VariableUtilities.substituteVariables(op, v1, v2, true, ctx);
    }

    public static void substituteVariablesInDescendantsAndSelf(ILogicalOperator op, LogicalVariable v1, LogicalVariable v2, ITypingContext ctx) throws AlgebricksException {
        for (Mutable<ILogicalOperator> childOp : op.getInputs()) {
            VariableUtilities.substituteVariablesInDescendantsAndSelf((ILogicalOperator)childOp.getValue(), v1, v2, ctx);
        }
        VariableUtilities.substituteVariables(op, v1, v2, true, ctx);
    }

    public static void substituteVariables(ILogicalOperator op, LogicalVariable v1, LogicalVariable v2, boolean goThroughNts, ITypingContext ctx) throws AlgebricksException {
        SubstituteVariableVisitor visitor = new SubstituteVariableVisitor(goThroughNts, ctx);
        op.accept(visitor, new Pair((Object)v1, (Object)v2));
    }

    public static <T> boolean varListEqualUnordered(List<T> var, List<T> varArg) {
        HashSet<T> varSet = new HashSet<T>();
        HashSet<T> varArgSet = new HashSet<T>();
        varSet.addAll(var);
        varArgSet.addAll(varArg);
        return varSet.equals(varArgSet);
    }
}

