/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.Pair;
import edu.uci.ics.hyracks.algebricks.common.utils.Triple;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.ExtensionOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.PartitioningSplitOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.HashPartitionExchangePOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.HashPartitionMergeExchangePOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.RangePartitionPOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.physical.SortMergeExchangePOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.OrderColumn;
import edu.uci.ics.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;

public class UsedVariableVisitor
implements ILogicalOperatorVisitor<Void, Void> {
    private Collection<LogicalVariable> usedVariables;

    public UsedVariableVisitor(Collection<LogicalVariable> usedVariables) {
        this.usedVariables = usedVariables;
    }

    @Override
    public Void visitAggregateOperator(AggregateOperator op, Void arg) {
        for (Mutable<ILogicalExpression> exprRef : op.getExpressions()) {
            ((ILogicalExpression)exprRef.getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitAssignOperator(AssignOperator op, Void arg) {
        for (Mutable<ILogicalExpression> exprRef : op.getExpressions()) {
            ((ILogicalExpression)exprRef.getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitDataScanOperator(DataSourceScanOperator op, Void arg) {
        return null;
    }

    @Override
    public Void visitDistinctOperator(DistinctOperator op, Void arg) {
        for (Mutable<ILogicalExpression> eRef : op.getExpressions()) {
            ((ILogicalExpression)eRef.getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Void arg) {
        return null;
    }

    @Override
    public Void visitExchangeOperator(ExchangeOperator op, Void arg) throws AlgebricksException {
        if (op.getPhysicalOperator() != null) {
            IPhysicalOperator physOp = op.getPhysicalOperator();
            switch (physOp.getOperatorTag()) {
                case BROADCAST_EXCHANGE: 
                case ONE_TO_ONE_EXCHANGE: 
                case RANDOM_MERGE_EXCHANGE: {
                    break;
                }
                case HASH_PARTITION_EXCHANGE: {
                    HashPartitionExchangePOperator concreteOp = (HashPartitionExchangePOperator)physOp;
                    this.usedVariables.addAll(concreteOp.getHashFields());
                    break;
                }
                case HASH_PARTITION_MERGE_EXCHANGE: {
                    HashPartitionMergeExchangePOperator concreteOp = (HashPartitionMergeExchangePOperator)physOp;
                    this.usedVariables.addAll(concreteOp.getPartitionFields());
                    for (OrderColumn orderCol : concreteOp.getOrderColumns()) {
                        this.usedVariables.add(orderCol.getColumn());
                    }
                    break;
                }
                case SORT_MERGE_EXCHANGE: {
                    SortMergeExchangePOperator concreteOp = (SortMergeExchangePOperator)physOp;
                    for (OrderColumn orderCol : concreteOp.getSortColumns()) {
                        this.usedVariables.add(orderCol.getColumn());
                    }
                    break;
                }
                case RANGE_PARTITION_EXCHANGE: {
                    RangePartitionPOperator concreteOp = (RangePartitionPOperator)physOp;
                    for (OrderColumn partCol : concreteOp.getPartitioningFields()) {
                        this.usedVariables.add(partCol.getColumn());
                    }
                    break;
                }
                default: {
                    throw new AlgebricksException("Unhandled physical operator tag '" + (Object)((Object)physOp.getOperatorTag()) + "'.");
                }
            }
        }
        return null;
    }

    @Override
    public Void visitGroupByOperator(GroupByOperator op, Void arg) throws AlgebricksException {
        for (ILogicalPlan iLogicalPlan : op.getNestedPlans()) {
            for (Mutable<ILogicalOperator> r : iLogicalPlan.getRoots()) {
                VariableUtilities.getUsedVariablesInDescendantsAndSelf((ILogicalOperator)r.getValue(), this.usedVariables);
            }
        }
        for (Pair pair : op.getGroupByList()) {
            ((ILogicalExpression)((Mutable)pair.second).getValue()).getUsedVariables(this.usedVariables);
        }
        for (Pair pair : op.getDecorList()) {
            ((ILogicalExpression)((Mutable)pair.second).getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitInnerJoinOperator(InnerJoinOperator op, Void arg) {
        ((ILogicalExpression)op.getCondition().getValue()).getUsedVariables(this.usedVariables);
        return null;
    }

    @Override
    public Void visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Void arg) {
        ((ILogicalExpression)op.getCondition().getValue()).getUsedVariables(this.usedVariables);
        return null;
    }

    @Override
    public Void visitLimitOperator(LimitOperator op, Void arg) {
        ((ILogicalExpression)op.getMaxObjects().getValue()).getUsedVariables(this.usedVariables);
        ILogicalExpression offsetExpr = (ILogicalExpression)op.getOffset().getValue();
        if (offsetExpr != null) {
            offsetExpr.getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Void arg) {
        return null;
    }

    @Override
    public Void visitOrderOperator(OrderOperator op, Void arg) {
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> oe : op.getOrderExpressions()) {
            ((ILogicalExpression)((Mutable)oe.second).getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitPartitioningSplitOperator(PartitioningSplitOperator op, Void arg) {
        for (Mutable<ILogicalExpression> e : op.getExpressions()) {
            ((ILogicalExpression)e.getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitProjectOperator(ProjectOperator op, Void arg) {
        List<LogicalVariable> parameterVariables = op.getVariables();
        for (LogicalVariable v : parameterVariables) {
            if (this.usedVariables.contains(v)) continue;
            this.usedVariables.add(v);
        }
        return null;
    }

    @Override
    public Void visitRunningAggregateOperator(RunningAggregateOperator op, Void arg) {
        for (Mutable<ILogicalExpression> exprRef : op.getExpressions()) {
            ((ILogicalExpression)exprRef.getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitScriptOperator(ScriptOperator op, Void arg) {
        ArrayList<LogicalVariable> parameterVariables = op.getInputVariables();
        for (LogicalVariable v : parameterVariables) {
            if (this.usedVariables.contains(v)) continue;
            this.usedVariables.add(v);
        }
        return null;
    }

    @Override
    public Void visitSelectOperator(SelectOperator op, Void arg) {
        ((ILogicalExpression)op.getCondition().getValue()).getUsedVariables(this.usedVariables);
        return null;
    }

    @Override
    public Void visitSubplanOperator(SubplanOperator op, Void arg) throws AlgebricksException {
        for (ILogicalPlan p : op.getNestedPlans()) {
            for (Mutable<ILogicalOperator> r : p.getRoots()) {
                VariableUtilities.getUsedVariablesInDescendantsAndSelf((ILogicalOperator)r.getValue(), this.usedVariables);
            }
        }
        return null;
    }

    @Override
    public Void visitUnionOperator(UnionAllOperator op, Void arg) {
        for (Triple<LogicalVariable, LogicalVariable, LogicalVariable> m : op.getVariableMappings()) {
            if (!this.usedVariables.contains(m.first)) {
                this.usedVariables.add((LogicalVariable)m.first);
            }
            if (this.usedVariables.contains(m.second)) continue;
            this.usedVariables.add((LogicalVariable)m.second);
        }
        return null;
    }

    @Override
    public Void visitUnnestMapOperator(UnnestMapOperator op, Void arg) {
        ((ILogicalExpression)op.getExpressionRef().getValue()).getUsedVariables(this.usedVariables);
        return null;
    }

    @Override
    public Void visitUnnestOperator(UnnestOperator op, Void arg) {
        ((ILogicalExpression)op.getExpressionRef().getValue()).getUsedVariables(this.usedVariables);
        return null;
    }

    @Override
    public Void visitWriteOperator(WriteOperator op, Void arg) {
        for (Mutable<ILogicalExpression> expr : op.getExpressions()) {
            ((ILogicalExpression)expr.getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitDistributeResultOperator(DistributeResultOperator op, Void arg) {
        for (Mutable<ILogicalExpression> expr : op.getExpressions()) {
            ((ILogicalExpression)expr.getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitWriteResultOperator(WriteResultOperator op, Void arg) {
        ((ILogicalExpression)op.getPayloadExpression().getValue()).getUsedVariables(this.usedVariables);
        for (Mutable<ILogicalExpression> e : op.getKeyExpressions()) {
            ((ILogicalExpression)e.getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitInsertDeleteOperator(InsertDeleteOperator op, Void arg) {
        ((ILogicalExpression)op.getPayloadExpression().getValue()).getUsedVariables(this.usedVariables);
        for (Mutable<ILogicalExpression> e : op.getPrimaryKeyExpressions()) {
            ((ILogicalExpression)e.getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitIndexInsertDeleteOperator(IndexInsertDeleteOperator op, Void arg) {
        for (Mutable<ILogicalExpression> e : op.getPrimaryKeyExpressions()) {
            ((ILogicalExpression)e.getValue()).getUsedVariables(this.usedVariables);
        }
        for (Mutable<ILogicalExpression> e : op.getSecondaryKeyExpressions()) {
            ((ILogicalExpression)e.getValue()).getUsedVariables(this.usedVariables);
        }
        return null;
    }

    @Override
    public Void visitSinkOperator(SinkOperator op, Void arg) {
        return null;
    }

    @Override
    public Void visitReplicateOperator(ReplicateOperator op, Void arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitExtensionOperator(ExtensionOperator op, Void arg) throws AlgebricksException {
        op.getDelegate().getUsedVariables(this.usedVariables);
        return null;
    }
}

