/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import edu.uci.ics.hyracks.algebricks.core.algebra.typing.ITypingContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import java.util.ArrayList;
import org.apache.commons.lang3.mutable.Mutable;

public class UnnestOperator
extends AbstractUnnestOperator {
    private LogicalVariable positionalVariable;
    private ILogicalExpression positionOffsetExpr;
    private Object positionalVariableType;

    public UnnestOperator(LogicalVariable variable, Mutable<ILogicalExpression> expression) {
        super(UnnestOperator.makeSingletonList(variable), expression);
    }

    public UnnestOperator(LogicalVariable variable, Mutable<ILogicalExpression> expression, LogicalVariable positionalVariable, Object positionalVariableType) {
        this(variable, expression);
        this.setPositionalVariable(positionalVariable);
        this.setPositionalVariableType(positionalVariableType);
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.UNNEST;
    }

    public LogicalVariable getVariable() {
        return (LogicalVariable)this.variables.get(0);
    }

    public void setPositionalVariable(LogicalVariable positionalVariable) {
        this.positionalVariable = positionalVariable;
    }

    public LogicalVariable getPositionalVariable() {
        return this.positionalVariable;
    }

    public void setPositionalVariableType(Object positionalVariableType) {
        this.positionalVariableType = positionalVariableType;
    }

    public Object getPositionalVariableType() {
        return this.positionalVariableType;
    }

    public void setPositionOffsetExpr(ILogicalExpression posOffsetExpr) {
        this.positionOffsetExpr = posOffsetExpr;
    }

    public ILogicalExpression getPositionOffsetExpr() {
        return this.positionOffsetExpr;
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitUnnestOperator(this, arg);
    }

    private static <E> ArrayList<E> makeSingletonList(E item) {
        ArrayList<E> array = new ArrayList<E>(1);
        array.add(item);
        return array;
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        IVariableTypeEnvironment env = this.createPropagatingAllInputsTypeEnvironment(ctx);
        Object t = env.getType((ILogicalExpression)this.expression.getValue());
        env.setVarType((LogicalVariable)this.variables.get(0), t);
        if (this.positionalVariable != null) {
            env.setVarType(this.positionalVariable, this.positionalVariableType);
        }
        return env;
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return new VariablePropagationPolicy(){

            @Override
            public void propagateVariables(IOperatorSchema target, IOperatorSchema ... sources) throws AlgebricksException {
                if (sources.length > 0) {
                    target.addAllVariables(sources[0]);
                }
                for (LogicalVariable v : UnnestOperator.this.variables) {
                    target.addVariable(v);
                }
                if (UnnestOperator.this.positionalVariable != null) {
                    target.addVariable(UnnestOperator.this.positionalVariable);
                }
            }
        };
    }
}

