/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.common.utils.Triple;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import edu.uci.ics.hyracks.algebricks.core.algebra.typing.ITypingContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.typing.NonPropagatingTypeEnvironment;
import edu.uci.ics.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import edu.uci.ics.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;

public class UnionAllOperator
extends AbstractLogicalOperator {
    private List<Triple<LogicalVariable, LogicalVariable, LogicalVariable>> varMap;

    public UnionAllOperator(List<Triple<LogicalVariable, LogicalVariable, LogicalVariable>> varMap) {
        this.varMap = varMap;
    }

    public List<Triple<LogicalVariable, LogicalVariable, LogicalVariable>> getVariableMappings() {
        return this.varMap;
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.UNIONALL;
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return new VariablePropagationPolicy(){

            @Override
            public void propagateVariables(IOperatorSchema target, IOperatorSchema ... sources) throws AlgebricksException {
                for (Triple t : UnionAllOperator.this.varMap) {
                    target.addVariable((LogicalVariable)t.third);
                }
            }
        };
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform visitor) throws AlgebricksException {
        return false;
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitUnionOperator(this, arg);
    }

    @Override
    public void recomputeSchema() {
        this.schema = new ArrayList();
        for (LogicalVariable v1 : ((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue()).getSchema()) {
            for (Triple<LogicalVariable, LogicalVariable, LogicalVariable> t : this.varMap) {
                if (((LogicalVariable)t.first).equals(v1)) {
                    this.schema.add(t.third);
                    continue;
                }
                this.schema.add(v1);
            }
        }
        for (LogicalVariable v2 : ((ILogicalOperator)((Mutable)this.inputs.get(1)).getValue()).getSchema()) {
            for (Triple<LogicalVariable, LogicalVariable, LogicalVariable> t : this.varMap) {
                if (((LogicalVariable)t.second).equals(v2)) {
                    this.schema.add(t.third);
                    continue;
                }
                this.schema.add(v2);
            }
        }
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        NonPropagatingTypeEnvironment env = new NonPropagatingTypeEnvironment(ctx.getExpressionTypeComputer(), ctx.getMetadataProvider());
        IVariableTypeEnvironment envLeft = ctx.getOutputTypeEnvironment((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue());
        if (envLeft == null) {
            throw new AlgebricksException("Left input types for union operator are not computed.");
        }
        for (Triple<LogicalVariable, LogicalVariable, LogicalVariable> t : this.varMap) {
            Object t1 = envLeft.getVarType((LogicalVariable)t.first);
            if (t1 == null) {
                throw new AlgebricksException("Failed typing union operator: no type for variable " + t.first);
            }
            env.setVarType((LogicalVariable)t.third, t1);
        }
        return env;
    }
}

