/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import edu.uci.ics.hyracks.algebricks.core.algebra.typing.ITypingContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import edu.uci.ics.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import java.util.ArrayList;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class LimitOperator
extends AbstractLogicalOperator {
    private final Mutable<ILogicalExpression> maxObjects;
    private final Mutable<ILogicalExpression> offset;
    private boolean topmost;

    public LimitOperator(ILogicalExpression maxObjectsExpr, ILogicalExpression offsetExpr, boolean topmost) {
        this.maxObjects = new MutableObject((Object)maxObjectsExpr);
        this.offset = new MutableObject((Object)offsetExpr);
        this.topmost = topmost;
    }

    public LimitOperator(ILogicalExpression maxObjectsExpr, boolean topmost) {
        this(maxObjectsExpr, null, topmost);
    }

    public LimitOperator(ILogicalExpression maxObjects, ILogicalExpression offset) {
        this(maxObjects, offset, true);
    }

    public LimitOperator(ILogicalExpression maxObjects) {
        this(maxObjects, null, true);
    }

    public Mutable<ILogicalExpression> getMaxObjects() {
        return this.maxObjects;
    }

    public Mutable<ILogicalExpression> getOffset() {
        return this.offset;
    }

    public boolean isTopmostLimitOp() {
        return this.topmost;
    }

    @Override
    public void recomputeSchema() {
        this.schema = new ArrayList();
        this.schema.addAll(((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue()).getSchema());
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitLimitOperator(this, arg);
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform visitor) throws AlgebricksException {
        boolean b = false;
        if (visitor.transform(this.maxObjects)) {
            b = true;
        }
        if (this.offset.getValue() != null && visitor.transform(this.offset)) {
            b = true;
        }
        return b;
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.LIMIT;
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return VariablePropagationPolicy.ALL;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        return this.createPropagatingAllInputsTypeEnvironment(ctx);
    }
}

