/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.AbstractAssignOperator;
import edu.uci.ics.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import edu.uci.ics.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import edu.uci.ics.hyracks.algebricks.core.algebra.typing.ITypingContext;
import edu.uci.ics.hyracks.algebricks.core.algebra.typing.NonPropagatingTypeEnvironment;
import edu.uci.ics.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;

public class AggregateOperator
extends AbstractAssignOperator {
    private List<Mutable<ILogicalExpression>> mergeExpressions;
    private boolean global = true;

    public AggregateOperator(List<LogicalVariable> variables, List<Mutable<ILogicalExpression>> expressions) {
        super(variables, expressions);
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.AGGREGATE;
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitAggregateOperator(this, arg);
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return new VariablePropagationPolicy(){

            @Override
            public void propagateVariables(IOperatorSchema target, IOperatorSchema ... sources) throws AlgebricksException {
                for (LogicalVariable v : AggregateOperator.this.variables) {
                    target.addVariable(v);
                }
            }
        };
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public void recomputeSchema() {
        this.schema = new ArrayList();
        this.schema.addAll(this.variables);
    }

    public void setMergeExpressions(List<Mutable<ILogicalExpression>> merges) {
        this.mergeExpressions = merges;
    }

    public List<Mutable<ILogicalExpression>> getMergeExpressions() {
        return this.mergeExpressions;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public boolean isGlobal() {
        return this.global;
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        NonPropagatingTypeEnvironment env = new NonPropagatingTypeEnvironment(ctx.getExpressionTypeComputer(), ctx.getMetadataProvider());
        IVariableTypeEnvironment env2 = ctx.getOutputTypeEnvironment((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue());
        int n = this.variables.size();
        for (int i = 0; i < n; ++i) {
            Object t = ctx.getExpressionTypeComputer().getType((ILogicalExpression)((Mutable)this.expressions.get(i)).getValue(), ctx.getMetadataProvider(), env2);
            env.setVarType((LogicalVariable)this.variables.get(i), t);
        }
        return env;
    }
}

