/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.expressions;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AbstractLogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;

public class VariableReferenceExpression
extends AbstractLogicalExpression {
    private int tupleRef;
    private LogicalVariable variable;

    public VariableReferenceExpression(int tupleRef, LogicalVariable variable) {
        this.tupleRef = tupleRef;
        this.variable = variable;
    }

    public VariableReferenceExpression(LogicalVariable variable) {
        this(0, variable);
    }

    public int getTupleRef() {
        return this.tupleRef;
    }

    public void setTupleRef(int tupleRef) {
        this.tupleRef = tupleRef;
    }

    public LogicalVariable getVariableReference() {
        return this.variable;
    }

    public void setVariable(LogicalVariable variable) {
        this.variable = variable;
    }

    @Override
    public LogicalExpressionTag getExpressionTag() {
        return LogicalExpressionTag.VARIABLE;
    }

    public String toString() {
        return "%" + this.tupleRef + "->" + this.variable.toString();
    }

    @Override
    public void getUsedVariables(Collection<LogicalVariable> vars) {
        vars.add(this.variable);
    }

    @Override
    public void substituteVar(LogicalVariable v1, LogicalVariable v2) {
        if (this.variable.equals(v1)) {
            this.variable = v2;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VariableReferenceExpression)) {
            return false;
        }
        return this.tupleRef == ((VariableReferenceExpression)obj).tupleRef && this.variable.equals(((VariableReferenceExpression)obj).getVariableReference());
    }

    public int hashCode() {
        return this.tupleRef + this.variable.getId();
    }

    @Override
    public <R, T> R accept(ILogicalExpressionVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitVariableReferenceExpression(this, arg);
    }

    @Override
    public AbstractLogicalExpression cloneExpression() {
        return new VariableReferenceExpression(this.variable);
    }

    @Override
    public boolean splitIntoConjuncts(List<Mutable<ILogicalExpression>> conjs) {
        return false;
    }
}

