/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.expressions;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.AbstractLogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import edu.uci.ics.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import edu.uci.ics.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;

public final class ConstantExpression
extends AbstractLogicalExpression {
    private IAlgebricksConstantValue value;
    public static final ConstantExpression TRUE = new ConstantExpression(new IAlgebricksConstantValue(){

        @Override
        public boolean isTrue() {
            return true;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        @Override
        public boolean isFalse() {
            return false;
        }

        public String toString() {
            return "TRUE";
        }
    });
    public static final ConstantExpression FALSE = new ConstantExpression(new IAlgebricksConstantValue(){

        @Override
        public boolean isTrue() {
            return false;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        @Override
        public boolean isFalse() {
            return true;
        }

        public String toString() {
            return "FALSE";
        }
    });
    public static final ConstantExpression NULL = new ConstantExpression(new IAlgebricksConstantValue(){

        @Override
        public boolean isTrue() {
            return false;
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public boolean isFalse() {
            return false;
        }

        public String toString() {
            return "NULL";
        }
    });
    private Map<Object, IExpressionAnnotation> annotationMap = new HashMap<Object, IExpressionAnnotation>();

    public ConstantExpression(IAlgebricksConstantValue value) {
        this.value = value;
    }

    public IAlgebricksConstantValue getValue() {
        return this.value;
    }

    public void setValue(IAlgebricksConstantValue value) {
        this.value = value;
    }

    @Override
    public LogicalExpressionTag getExpressionTag() {
        return LogicalExpressionTag.CONSTANT;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public void getUsedVariables(Collection<LogicalVariable> vars) {
    }

    @Override
    public void substituteVar(LogicalVariable v1, LogicalVariable v2) {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConstantExpression)) {
            return false;
        }
        return this.value.equals(((ConstantExpression)obj).getValue());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public <R, T> R accept(ILogicalExpressionVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitConstantExpression(this, arg);
    }

    @Override
    public AbstractLogicalExpression cloneExpression() {
        HashMap<Object, IExpressionAnnotation> m = new HashMap<Object, IExpressionAnnotation>();
        for (Object k : this.annotationMap.keySet()) {
            IExpressionAnnotation annot2 = this.annotationMap.get(k).copy();
            m.put(k, annot2);
        }
        ConstantExpression c = new ConstantExpression(this.value);
        c.annotationMap = m;
        return c;
    }

    public Map<Object, IExpressionAnnotation> getAnnotations() {
        return this.annotationMap;
    }

    @Override
    public boolean splitIntoConjuncts(List<Mutable<ILogicalExpression>> conjs) {
        return false;
    }
}

