/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.algebricks.core.algebra.base;

import edu.uci.ics.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import edu.uci.ics.hyracks.algebricks.core.algebra.base.LogicalVariable;
import java.util.LinkedList;
import java.util.List;

public final class EquivalenceClass {
    private List<LogicalVariable> members;
    private ILogicalExpression constRepresentative;
    private LogicalVariable variableRepresentative;
    private boolean representativeIsConst;

    public EquivalenceClass(List<LogicalVariable> members, ILogicalExpression constRepresentative) {
        this.members = members;
        this.constRepresentative = constRepresentative;
        this.representativeIsConst = true;
    }

    public EquivalenceClass(List<LogicalVariable> members, LogicalVariable variableRepresentative) {
        this.members = members;
        this.variableRepresentative = variableRepresentative;
        this.representativeIsConst = false;
    }

    public boolean representativeIsConst() {
        return this.representativeIsConst;
    }

    public List<LogicalVariable> getMembers() {
        return this.members;
    }

    public boolean contains(LogicalVariable var) {
        return this.members.contains(var);
    }

    public ILogicalExpression getConstRepresentative() {
        return this.constRepresentative;
    }

    public LogicalVariable getVariableRepresentative() {
        return this.variableRepresentative;
    }

    public void setConstRepresentative(ILogicalExpression constRepresentative) {
        this.constRepresentative = constRepresentative;
        this.representativeIsConst = true;
    }

    public void setVariableRepresentative(LogicalVariable variableRepresentative) {
        this.variableRepresentative = variableRepresentative;
        this.representativeIsConst = false;
    }

    public void merge(EquivalenceClass ec2) {
        this.members.addAll(ec2.getMembers());
        if (!this.representativeIsConst && ec2.representativeIsConst()) {
            this.representativeIsConst = true;
            this.constRepresentative = ec2.getConstRepresentative();
        }
    }

    public void addMember(LogicalVariable v) {
        this.members.add(v);
    }

    public EquivalenceClass cloneEquivalenceClass() {
        LinkedList<LogicalVariable> membersClone = new LinkedList<LogicalVariable>();
        membersClone.addAll(this.members);
        EquivalenceClass ec = this.representativeIsConst() ? new EquivalenceClass(membersClone, this.constRepresentative) : new EquivalenceClass(membersClone, this.variableRepresentative);
        return ec;
    }

    public String toString() {
        return "(<" + (this.representativeIsConst ? this.constRepresentative : this.variableRepresentative) + "> " + this.members + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EquivalenceClass)) {
            return false;
        }
        EquivalenceClass ec = (EquivalenceClass)obj;
        if (!this.members.equals(ec.getMembers())) {
            return false;
        }
        if (this.representativeIsConst) {
            return ec.representativeIsConst() && this.constRepresentative.equals(ec.getConstRepresentative());
        }
        return !ec.representativeIsConst() && this.variableRepresentative.equals(ec.getVariableRepresentative());
    }
}

