/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.common.file;

import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.storage.common.file.ILocalResourceRepository;
import edu.uci.ics.hyracks.storage.common.file.LocalResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransientLocalResourceRepository
implements ILocalResourceRepository {
    private Map<String, LocalResource> name2ResourceMap = new HashMap<String, LocalResource>();
    private Map<Long, LocalResource> id2ResourceMap = new HashMap<Long, LocalResource>();

    @Override
    public LocalResource getResourceById(long id) throws HyracksDataException {
        return this.id2ResourceMap.get(id);
    }

    @Override
    public LocalResource getResourceByName(String name) throws HyracksDataException {
        return this.name2ResourceMap.get(name);
    }

    @Override
    public synchronized void insert(LocalResource resource) throws HyracksDataException {
        long id = resource.getResourceId();
        if (this.id2ResourceMap.containsKey(id)) {
            throw new HyracksDataException("Duplicate resource");
        }
        this.id2ResourceMap.put(id, resource);
        this.name2ResourceMap.put(resource.getResourceName(), resource);
    }

    @Override
    public synchronized void deleteResourceById(long id) throws HyracksDataException {
        LocalResource resource = this.id2ResourceMap.get(id);
        if (resource == null) {
            throw new HyracksDataException("Resource doesn't exist");
        }
        this.id2ResourceMap.remove(id);
        this.name2ResourceMap.remove(resource.getResourceName());
    }

    @Override
    public synchronized void deleteResourceByName(String name) throws HyracksDataException {
        LocalResource resource = this.name2ResourceMap.get(name);
        if (resource == null) {
            throw new HyracksDataException("Resource doesn't exist");
        }
        this.id2ResourceMap.remove(resource.getResourceId());
        this.name2ResourceMap.remove(name);
    }

    @Override
    public List<LocalResource> getAllResources() throws HyracksDataException {
        ArrayList<LocalResource> resources = new ArrayList<LocalResource>();
        for (LocalResource resource : this.id2ResourceMap.values()) {
            resources.add(resource);
        }
        return resources;
    }
}

