/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.common.file;

import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.storage.common.file.ILocalResourceRepository;
import edu.uci.ics.hyracks.storage.common.file.LocalResource;
import edu.uci.ics.hyracks.storage.common.file.ResourceIdFactory;
import java.util.List;

public class ResourceIdFactoryProvider {
    private ILocalResourceRepository localResourceRepository;

    public ResourceIdFactoryProvider(ILocalResourceRepository localResourceRepository) {
        this.localResourceRepository = localResourceRepository;
    }

    public ResourceIdFactory createResourceIdFactory() throws HyracksDataException {
        List<LocalResource> localResources = this.localResourceRepository.getAllResources();
        long largestResourceId = 0L;
        for (LocalResource localResource : localResources) {
            if (largestResourceId >= localResource.getResourceId()) continue;
            largestResourceId = localResource.getResourceId();
        }
        return new ResourceIdFactory(largestResourceId);
    }
}

