/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.common.file;

import edu.uci.ics.hyracks.api.io.IFileHandle;
import java.util.concurrent.atomic.AtomicInteger;

public class BufferedFileHandle {
    private final int fileId;
    private IFileHandle handle;
    private final AtomicInteger refCount;

    public BufferedFileHandle(int fileId, IFileHandle handle) {
        this.fileId = fileId;
        this.handle = handle;
        this.refCount = new AtomicInteger();
    }

    public int getFileId() {
        return this.fileId;
    }

    public IFileHandle getFileHandle() {
        return this.handle;
    }

    public void markAsDeleted() {
        this.handle = null;
    }

    public boolean fileHasBeenDeleted() {
        return this.handle == null;
    }

    public int incReferenceCount() {
        return this.refCount.incrementAndGet();
    }

    public int decReferenceCount() {
        return this.refCount.decrementAndGet();
    }

    public int getReferenceCount() {
        return this.refCount.get();
    }

    public long getDiskPageId(int pageId) {
        return BufferedFileHandle.getDiskPageId(this.fileId, pageId);
    }

    public static long getDiskPageId(int fileId, int pageId) {
        return ((long)fileId << 32) + (long)pageId;
    }

    public static int getFileId(long dpid) {
        return (int)(dpid >> 32 & 0xFFFFFFFFFFFFFFFFL);
    }

    public static int getPageId(long dpid) {
        return (int)(dpid & 0xFFFFFFFFFFFFFFFFL);
    }
}

