/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.common.buffercache;

import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.storage.common.buffercache.IBufferCache;
import edu.uci.ics.hyracks.storage.common.buffercache.ICachedPage;
import java.util.concurrent.atomic.AtomicLong;

public class DebugBufferCache
implements IBufferCache {
    private final IBufferCache bufferCache;
    private AtomicLong pinCount = new AtomicLong();
    private AtomicLong unpinCount = new AtomicLong();
    private AtomicLong readLatchCount = new AtomicLong();
    private AtomicLong readUnlatchCount = new AtomicLong();
    private AtomicLong writeLatchCount = new AtomicLong();
    private AtomicLong writeUnlatchCount = new AtomicLong();
    private AtomicLong createFileCount = new AtomicLong();
    private AtomicLong deleteFileCount = new AtomicLong();
    private AtomicLong openFileCount = new AtomicLong();
    private AtomicLong closeFileCount = new AtomicLong();

    public DebugBufferCache(IBufferCache bufferCache) {
        this.bufferCache = bufferCache;
        this.resetCounters();
    }

    @Override
    public void createFile(FileReference fileRef) throws HyracksDataException {
        this.bufferCache.createFile(fileRef);
        this.createFileCount.addAndGet(1L);
    }

    @Override
    public void openFile(int fileId) throws HyracksDataException {
        this.bufferCache.openFile(fileId);
        this.openFileCount.addAndGet(1L);
    }

    @Override
    public void closeFile(int fileId) throws HyracksDataException {
        this.bufferCache.closeFile(fileId);
        this.closeFileCount.addAndGet(1L);
    }

    @Override
    public void deleteFile(int fileId, boolean flushDirtyPages) throws HyracksDataException {
        this.bufferCache.deleteFile(fileId, flushDirtyPages);
        this.deleteFileCount.addAndGet(1L);
    }

    @Override
    public ICachedPage tryPin(long dpid) throws HyracksDataException {
        return this.bufferCache.tryPin(dpid);
    }

    @Override
    public ICachedPage pin(long dpid, boolean newPage) throws HyracksDataException {
        ICachedPage page = this.bufferCache.pin(dpid, newPage);
        this.pinCount.addAndGet(1L);
        return page;
    }

    @Override
    public void unpin(ICachedPage page) throws HyracksDataException {
        this.bufferCache.unpin(page);
        this.unpinCount.addAndGet(1L);
    }

    @Override
    public int getPageSize() {
        return this.bufferCache.getPageSize();
    }

    @Override
    public int getNumPages() {
        return this.bufferCache.getNumPages();
    }

    @Override
    public void close() throws HyracksDataException {
        this.bufferCache.close();
    }

    public void resetCounters() {
        this.pinCount.set(0L);
        this.unpinCount.set(0L);
        this.readLatchCount.set(0L);
        this.readUnlatchCount.set(0L);
        this.writeLatchCount.set(0L);
        this.writeUnlatchCount.set(0L);
        this.createFileCount.set(0L);
        this.deleteFileCount.set(0L);
        this.openFileCount.set(0L);
        this.closeFileCount.set(0L);
    }

    public long getPinCount() {
        return this.pinCount.get();
    }

    public long getUnpinCount() {
        return this.unpinCount.get();
    }

    public long getReadLatchCount() {
        return this.readLatchCount.get();
    }

    public long getReadUnlatchCount() {
        return this.readUnlatchCount.get();
    }

    public long getWriteLatchCount() {
        return this.writeLatchCount.get();
    }

    public long getWriteUnlatchCount() {
        return this.writeUnlatchCount.get();
    }

    public long getCreateFileCount() {
        return this.createFileCount.get();
    }

    public long getDeleteFileCount() {
        return this.deleteFileCount.get();
    }

    public long getOpenFileCount() {
        return this.openFileCount.get();
    }

    public long getCloseFileCount() {
        return this.closeFileCount.get();
    }

    @Override
    public void flushDirtyPage(ICachedPage page) throws HyracksDataException {
        this.bufferCache.flushDirtyPage(page);
    }

    @Override
    public void force(int fileId, boolean metadata) throws HyracksDataException {
        this.bufferCache.force(fileId, metadata);
    }
}

