/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.common.buffercache;

import edu.uci.ics.hyracks.storage.common.buffercache.IBufferCacheInternal;
import edu.uci.ics.hyracks.storage.common.buffercache.ICachedPageInternal;
import edu.uci.ics.hyracks.storage.common.buffercache.IPageReplacementStrategy;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ClockPageReplacementStrategy
implements IPageReplacementStrategy {
    private static final int MAX_UNSUCCESSFUL_CYCLE_COUNT = 3;
    private final Lock lock = new ReentrantLock();
    private IBufferCacheInternal bufferCache;
    private int clockPtr = 0;

    @Override
    public Object createPerPageStrategyObject(int cpid) {
        return new AtomicBoolean();
    }

    @Override
    public void setBufferCache(IBufferCacheInternal bufferCache) {
        this.bufferCache = bufferCache;
    }

    @Override
    public void notifyCachePageReset(ICachedPageInternal cPage) {
        this.getPerPageObject(cPage).set(false);
    }

    @Override
    public void notifyCachePageAccess(ICachedPageInternal cPage) {
        this.getPerPageObject(cPage).set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICachedPageInternal findVictim() {
        this.lock.lock();
        try {
            int startClockPtr = this.clockPtr;
            int cycleCount = 0;
            do {
                ICachedPageInternal cPage;
                AtomicBoolean accessedFlag;
                if (!(accessedFlag = this.getPerPageObject(cPage = this.bufferCache.getPage(this.clockPtr))).compareAndSet(true, false) && cPage.pinIfGoodVictim()) {
                    ICachedPageInternal iCachedPageInternal = cPage;
                    return iCachedPageInternal;
                }
                this.clockPtr = (this.clockPtr + 1) % this.bufferCache.getNumPages();
                if (this.clockPtr != startClockPtr) continue;
                ++cycleCount;
            } while (cycleCount < 3);
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    private AtomicBoolean getPerPageObject(ICachedPageInternal cPage) {
        return (AtomicBoolean)cPage.getReplacementStrategyObject();
    }
}

