/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.common.buffercache;

import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.api.io.IFileHandle;
import edu.uci.ics.hyracks.api.io.IIOManager;
import edu.uci.ics.hyracks.api.lifecycle.ILifeCycleComponent;
import edu.uci.ics.hyracks.storage.common.buffercache.IBufferCacheInternal;
import edu.uci.ics.hyracks.storage.common.buffercache.ICacheMemoryAllocator;
import edu.uci.ics.hyracks.storage.common.buffercache.ICachedPage;
import edu.uci.ics.hyracks.storage.common.buffercache.ICachedPageInternal;
import edu.uci.ics.hyracks.storage.common.buffercache.IPageCleanerPolicy;
import edu.uci.ics.hyracks.storage.common.buffercache.IPageReplacementStrategy;
import edu.uci.ics.hyracks.storage.common.file.BufferedFileHandle;
import edu.uci.ics.hyracks.storage.common.file.IFileMapManager;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BufferCache
implements IBufferCacheInternal,
ILifeCycleComponent {
    private static final Logger LOGGER = Logger.getLogger(BufferCache.class.getName());
    private static final int MAP_FACTOR = 2;
    private static final int MIN_CLEANED_COUNT_DIFF = 3;
    private static final int PIN_MAX_WAIT_TIME = 50;
    private final int maxOpenFiles;
    private final IIOManager ioManager;
    private final int pageSize;
    private final int numPages;
    private final CacheBucket[] pageMap;
    private final IPageReplacementStrategy pageReplacementStrategy;
    private final IPageCleanerPolicy pageCleanerPolicy;
    private final IFileMapManager fileMapManager;
    private final CleanerThread cleanerThread;
    private final Map<Integer, BufferedFileHandle> fileInfoMap;
    private CachedPage[] cachedPages;
    private boolean closed;

    public BufferCache(IIOManager ioManager, ICacheMemoryAllocator allocator, IPageReplacementStrategy pageReplacementStrategy, IPageCleanerPolicy pageCleanerPolicy, IFileMapManager fileMapManager, int pageSize, int numPages, int maxOpenFiles, ThreadFactory threadFactory) {
        this.ioManager = ioManager;
        this.pageSize = pageSize;
        this.numPages = numPages;
        this.maxOpenFiles = maxOpenFiles;
        pageReplacementStrategy.setBufferCache(this);
        this.pageMap = new CacheBucket[numPages * 2];
        for (int i = 0; i < this.pageMap.length; ++i) {
            this.pageMap[i] = new CacheBucket();
        }
        ByteBuffer[] buffers = allocator.allocate(pageSize, numPages);
        this.cachedPages = new CachedPage[buffers.length];
        for (int i = 0; i < buffers.length; ++i) {
            this.cachedPages[i] = new CachedPage(i, buffers[i], pageReplacementStrategy);
        }
        this.pageReplacementStrategy = pageReplacementStrategy;
        this.pageCleanerPolicy = pageCleanerPolicy;
        this.fileMapManager = fileMapManager;
        ExecutorService executor = Executors.newCachedThreadPool(threadFactory);
        this.fileInfoMap = new HashMap<Integer, BufferedFileHandle>();
        this.cleanerThread = new CleanerThread();
        executor.execute(this.cleanerThread);
        this.closed = false;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getNumPages() {
        return this.numPages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pinSanityCheck(long dpid) throws HyracksDataException {
        if (this.closed) {
            throw new HyracksDataException("pin called on a closed cache");
        }
        int fileId = BufferedFileHandle.getFileId(dpid);
        BufferedFileHandle fInfo = null;
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            fInfo = this.fileInfoMap.get(fileId);
        }
        if (fInfo == null) {
            throw new HyracksDataException("pin called on a fileId " + fileId + " that has not been created.");
        }
        if (fInfo.getReferenceCount() <= 0) {
            throw new HyracksDataException("pin called on a fileId " + fileId + " that has not been opened.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICachedPage tryPin(long dpid) throws HyracksDataException {
        CachedPage cPage = null;
        int hash = this.hash(dpid);
        CacheBucket bucket = this.pageMap[hash];
        bucket.bucketLock.lock();
        try {
            cPage = bucket.cachedPage;
            while (cPage != null) {
                if (cPage.dpid == dpid) {
                    cPage.pinCount.incrementAndGet();
                    this.pageReplacementStrategy.notifyCachePageAccess(cPage);
                    CachedPage cachedPage = cPage;
                    return cachedPage;
                }
                cPage = cPage.next;
            }
        }
        finally {
            bucket.bucketLock.unlock();
        }
        return cPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICachedPage pin(long dpid, boolean newPage) throws HyracksDataException {
        CachedPage cPage = this.findPage(dpid, newPage);
        if (!newPage) {
            CachedPage cachedPage = cPage;
            synchronized (cachedPage) {
                if (!cPage.valid) {
                    this.read(cPage);
                    cPage.valid = true;
                }
            }
        } else {
            cPage.valid = true;
        }
        this.pageReplacementStrategy.notifyCachePageAccess(cPage);
        return cPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedPage findPage(long dpid, boolean newPage) throws HyracksDataException {
        while (true) {
            int startCleanedCount = this.cleanerThread.cleanedCount;
            CachedPage cPage = null;
            int hash = this.hash(dpid);
            CacheBucket bucket = this.pageMap[hash];
            bucket.bucketLock.lock();
            try {
                cPage = bucket.cachedPage;
                while (cPage != null) {
                    if (cPage.dpid == dpid) {
                        cPage.pinCount.incrementAndGet();
                        CachedPage cachedPage = cPage;
                        return cachedPage;
                    }
                    cPage = cPage.next;
                }
            }
            finally {
                bucket.bucketLock.unlock();
            }
            CachedPage victim = (CachedPage)this.pageReplacementStrategy.findVictim();
            if (victim != null) {
                if (victim.dpid < 0L) {
                    bucket.bucketLock.lock();
                    try {
                        cPage = bucket.cachedPage;
                        while (cPage != null) {
                            if (cPage.dpid == dpid) {
                                cPage.pinCount.incrementAndGet();
                                victim.pinCount.decrementAndGet();
                                CachedPage cachedPage = cPage;
                                return cachedPage;
                            }
                            cPage = cPage.next;
                        }
                        victim.reset(dpid);
                        victim.next = bucket.cachedPage;
                        bucket.cachedPage = victim;
                    }
                    finally {
                        bucket.bucketLock.unlock();
                    }
                    return victim;
                }
                int victimHash = this.hash(victim.dpid);
                if (victimHash == hash) {
                    bucket.bucketLock.lock();
                    try {
                        if (victim.pinCount.get() != 1) {
                            victim.pinCount.decrementAndGet();
                            continue;
                        }
                        cPage = bucket.cachedPage;
                        while (cPage != null) {
                            if (cPage.dpid == dpid) {
                                cPage.pinCount.incrementAndGet();
                                victim.pinCount.decrementAndGet();
                                CachedPage cachedPage = cPage;
                                return cachedPage;
                            }
                            cPage = cPage.next;
                        }
                        victim.reset(dpid);
                    }
                    finally {
                        bucket.bucketLock.unlock();
                        continue;
                    }
                    return victim;
                }
                CacheBucket victimBucket = this.pageMap[victimHash];
                if (victimHash < hash) {
                    victimBucket.bucketLock.lock();
                    bucket.bucketLock.lock();
                } else {
                    bucket.bucketLock.lock();
                    victimBucket.bucketLock.lock();
                }
                try {
                    if (victim.pinCount.get() != 1) {
                        victim.pinCount.decrementAndGet();
                        continue;
                    }
                    cPage = bucket.cachedPage;
                    while (cPage != null) {
                        if (cPage.dpid == dpid) {
                            cPage.pinCount.incrementAndGet();
                            victim.pinCount.decrementAndGet();
                            CachedPage cachedPage = cPage;
                            return cachedPage;
                        }
                        cPage = cPage.next;
                    }
                    if (victimBucket.cachedPage == victim) {
                        victimBucket.cachedPage = victim.next;
                    } else {
                        CachedPage victimPrev = victimBucket.cachedPage;
                        while (victimPrev != null && victimPrev.next != victim) {
                            victimPrev = victimPrev.next;
                        }
                        assert (victimPrev != null);
                        victimPrev.next = victim.next;
                    }
                    victim.reset(dpid);
                    victim.next = bucket.cachedPage;
                    bucket.cachedPage = victim;
                }
                finally {
                    victimBucket.bucketLock.unlock();
                    bucket.bucketLock.unlock();
                    continue;
                }
                return victim;
            }
            Object object = this.cleanerThread;
            synchronized (object) {
                this.pageCleanerPolicy.notifyVictimNotFound(this.cleanerThread);
            }
            if (this.cleanerThread.cleanedCount - startCleanedCount > 3) continue;
            object = this.cleanerThread.cleanNotification;
            synchronized (object) {
                try {
                    this.cleanerThread.cleanNotification.wait(50L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dumpState() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Buffer cache state\n");
        buffer.append("Page Size: ").append(this.pageSize).append('\n');
        buffer.append("Number of physical pages: ").append(this.numPages).append('\n');
        buffer.append("Hash table size: ").append(this.pageMap.length).append('\n');
        buffer.append("Page Map:\n");
        int nCachedPages = 0;
        for (int i = 0; i < this.pageMap.length; ++i) {
            CacheBucket cb = this.pageMap[i];
            cb.bucketLock.lock();
            try {
                CachedPage cp = cb.cachedPage;
                if (cp == null) continue;
                buffer.append("   ").append(i).append('\n');
                while (cp != null) {
                    buffer.append("      ").append(cp.cpid).append(" -> [").append(BufferedFileHandle.getFileId(cp.dpid)).append(':').append(BufferedFileHandle.getPageId(cp.dpid)).append(", ").append(cp.pinCount.get()).append(", ").append(cp.valid ? "valid" : "invalid").append(", ").append(cp.dirty.get() ? "dirty" : "clean").append("]\n");
                    cp = cp.next;
                    ++nCachedPages;
                }
                continue;
            }
            finally {
                cb.bucketLock.unlock();
            }
        }
        buffer.append("Number of cached pages: ").append(nCachedPages).append('\n');
        return buffer.toString();
    }

    private void read(CachedPage cPage) throws HyracksDataException {
        BufferedFileHandle fInfo = this.getFileInfo(cPage);
        cPage.buffer.clear();
        this.ioManager.syncRead(fInfo.getFileHandle(), (long)BufferedFileHandle.getPageId(cPage.dpid) * (long)this.pageSize, cPage.buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedFileHandle getFileInfo(CachedPage cPage) throws HyracksDataException {
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            BufferedFileHandle fInfo = this.fileInfoMap.get(BufferedFileHandle.getFileId(cPage.dpid));
            if (fInfo == null) {
                throw new HyracksDataException("No such file mapped");
            }
            return fInfo;
        }
    }

    private void write(CachedPage cPage) throws HyracksDataException {
        BufferedFileHandle fInfo = this.getFileInfo(cPage);
        if (fInfo.fileHasBeenDeleted()) {
            return;
        }
        cPage.buffer.position(0);
        cPage.buffer.limit(this.pageSize);
        this.ioManager.syncWrite(fInfo.getFileHandle(), (long)BufferedFileHandle.getPageId(cPage.dpid) * (long)this.pageSize, cPage.buffer);
    }

    @Override
    public void unpin(ICachedPage page) throws HyracksDataException {
        if (this.closed) {
            throw new HyracksDataException("unpin called on a closed cache");
        }
        ((CachedPage)page).pinCount.decrementAndGet();
    }

    private int hash(long dpid) {
        return (int)(dpid % (long)this.pageMap.length);
    }

    @Override
    public ICachedPageInternal getPage(int cpid) {
        return this.cachedPages[cpid];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.closed = true;
        Object object = this.cleanerThread;
        synchronized (object) {
            this.cleanerThread.shutdownStart = true;
            this.cleanerThread.notifyAll();
            while (!this.cleanerThread.shutdownComplete) {
                try {
                    this.cleanerThread.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        object = this.fileInfoMap;
        synchronized (object) {
            try {
                for (Map.Entry<Integer, BufferedFileHandle> entry : this.fileInfoMap.entrySet()) {
                    boolean fileHasBeenDeleted = entry.getValue().fileHasBeenDeleted();
                    this.sweepAndFlush(entry.getKey(), !fileHasBeenDeleted);
                    if (fileHasBeenDeleted) continue;
                    this.ioManager.close(entry.getValue().getFileHandle());
                }
            }
            catch (HyracksDataException e) {
                e.printStackTrace();
            }
            this.fileInfoMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFile(FileReference fileRef) throws HyracksDataException {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Creating file: " + fileRef + " in cache: " + this);
        }
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            this.fileMapManager.registerFile(fileRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFile(int fileId) throws HyracksDataException {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Opening file: " + fileId + " in cache: " + this);
        }
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            BufferedFileHandle fInfo = this.fileInfoMap.get(fileId);
            if (fInfo == null) {
                boolean unreferencedFileFound = true;
                block3: while (this.fileInfoMap.size() >= this.maxOpenFiles && unreferencedFileFound) {
                    unreferencedFileFound = false;
                    for (Map.Entry<Integer, BufferedFileHandle> entry : this.fileInfoMap.entrySet()) {
                        if (entry.getValue().getReferenceCount() > 0) continue;
                        int entryFileId = entry.getKey();
                        boolean fileHasBeenDeleted = entry.getValue().fileHasBeenDeleted();
                        this.sweepAndFlush(entryFileId, !fileHasBeenDeleted);
                        if (!fileHasBeenDeleted) {
                            this.ioManager.close(entry.getValue().getFileHandle());
                        }
                        this.fileInfoMap.remove(entryFileId);
                        unreferencedFileFound = true;
                        continue block3;
                    }
                }
                if (this.fileInfoMap.size() >= this.maxOpenFiles) {
                    throw new HyracksDataException("Could not open fileId " + fileId + ". Max number of files " + this.maxOpenFiles + " already opened and referenced.");
                }
                FileReference fileRef = this.fileMapManager.lookupFileName(fileId);
                IFileHandle fh = this.ioManager.open(fileRef, IIOManager.FileReadWriteMode.READ_WRITE, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
                fInfo = new BufferedFileHandle(fileId, fh);
                this.fileInfoMap.put(fileId, fInfo);
            }
            fInfo.incReferenceCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sweepAndFlush(int fileId, boolean flushDirtyPages) throws HyracksDataException {
        for (int i = 0; i < this.pageMap.length; ++i) {
            CacheBucket bucket = this.pageMap[i];
            bucket.bucketLock.lock();
            try {
                CachedPage cPage;
                CachedPage prev = bucket.cachedPage;
                while (prev != null && (cPage = prev.next) != null) {
                    if (this.invalidateIfFileIdMatch(fileId, cPage, flushDirtyPages)) {
                        prev.next = cPage.next;
                        cPage.next = null;
                        continue;
                    }
                    prev = cPage;
                }
                if (bucket.cachedPage == null || !this.invalidateIfFileIdMatch(fileId, bucket.cachedPage, flushDirtyPages)) continue;
                cPage = bucket.cachedPage;
                bucket.cachedPage = ((CacheBucket)bucket).cachedPage.next;
                cPage.next = null;
                continue;
            }
            finally {
                bucket.bucketLock.unlock();
            }
        }
    }

    private boolean invalidateIfFileIdMatch(int fileId, CachedPage cPage, boolean flushDirtyPages) throws HyracksDataException {
        if (BufferedFileHandle.getFileId(cPage.dpid) == fileId) {
            int pinCount = -1;
            if (cPage.dirty.get()) {
                if (flushDirtyPages) {
                    this.write(cPage);
                }
                cPage.dirty.set(false);
                pinCount = cPage.pinCount.decrementAndGet();
            } else {
                pinCount = cPage.pinCount.get();
            }
            if (pinCount != 0) {
                throw new IllegalStateException("Page is pinned and file is being closed. Pincount is: " + pinCount);
            }
            cPage.invalidate();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFile(int fileId) throws HyracksDataException {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Closing file: " + fileId + " in cache: " + this);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(this.dumpState());
        }
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            BufferedFileHandle fInfo = this.fileInfoMap.get(fileId);
            if (fInfo == null) {
                throw new HyracksDataException("Closing unopened file");
            }
            if (fInfo.decReferenceCount() < 0) {
                throw new HyracksDataException("Closed fileId: " + fileId + " more times than it was opened.");
            }
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Closed file: " + fileId + " in cache: " + this);
        }
    }

    @Override
    public void flushDirtyPage(ICachedPage page) throws HyracksDataException {
        this.cleanerThread.cleanPage((CachedPage)page, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force(int fileId, boolean metadata) throws HyracksDataException {
        BufferedFileHandle fInfo = null;
        Map<Integer, BufferedFileHandle> map = this.fileInfoMap;
        synchronized (map) {
            fInfo = this.fileInfoMap.get(fileId);
        }
        this.ioManager.sync(fInfo.getFileHandle(), metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void deleteFile(int fileId, boolean flushDirtyPages) throws HyracksDataException {
        Map<Integer, BufferedFileHandle> map;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Deleting file: " + fileId + " in cache: " + this);
        }
        if (flushDirtyPages) {
            map = this.fileInfoMap;
            synchronized (map) {
                this.sweepAndFlush(fileId, flushDirtyPages);
            }
        }
        map = this.fileInfoMap;
        synchronized (map) {
            BufferedFileHandle fInfo = null;
            try {
                fInfo = this.fileInfoMap.get(fileId);
                if (fInfo != null && fInfo.getReferenceCount() > 0) {
                    throw new HyracksDataException("Deleting open file");
                }
            }
            finally {
                this.fileMapManager.unregisterFile(fileId);
                if (fInfo != null && !fInfo.fileHasBeenDeleted()) {
                    this.ioManager.close(fInfo.getFileHandle());
                    fInfo.markAsDeleted();
                }
            }
        }
    }

    public void start() {
    }

    public void stop(boolean dumpState, OutputStream os) throws IOException {
        if (dumpState) {
            this.dumpState(os);
        }
        this.close();
    }

    public void dumpState(OutputStream os) throws IOException {
        os.write(this.dumpState().getBytes());
    }

    private class CleanerThread
    extends Thread {
        private boolean shutdownStart = false;
        private boolean shutdownComplete = false;
        private final Object cleanNotification = new Object();
        private int cleanedCount = 0;

        public CleanerThread() {
            this.setPriority(10);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void cleanPage(CachedPage cPage, boolean force) {
            if (!cPage.dirty.get()) return;
            boolean proceed = false;
            if (force) {
                cPage.latch.writeLock().lock();
                proceed = true;
            } else {
                proceed = cPage.latch.readLock().tryLock();
            }
            if (proceed) {
                try {
                    if (!cPage.dirty.get()) {
                        return;
                    }
                    boolean cleaned = true;
                    try {
                        BufferCache.this.write(cPage);
                    }
                    catch (HyracksDataException e) {
                        cleaned = false;
                    }
                    if (!cleaned) return;
                    cPage.dirty.set(false);
                    cPage.pinCount.decrementAndGet();
                    ++this.cleanedCount;
                    Object object = this.cleanNotification;
                    synchronized (object) {
                        this.cleanNotification.notifyAll();
                        return;
                    }
                }
                finally {
                    if (force) {
                        cPage.latch.writeLock().unlock();
                    } else {
                        cPage.latch.readLock().unlock();
                    }
                }
            }
            if (!this.shutdownStart) return;
            throw new IllegalStateException("Cache closed, but unable to acquire read lock on dirty page: " + cPage.dpid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            try {
                while (true) {
                    BufferCache.this.pageCleanerPolicy.notifyCleanCycleStart(this);
                    for (int i = 0; i < BufferCache.this.numPages; ++i) {
                        CachedPage cPage = BufferCache.this.cachedPages[i];
                        this.cleanPage(cPage, false);
                    }
                    if (this.shutdownStart) {
                        break;
                    }
                    BufferCache.this.pageCleanerPolicy.notifyCleanCycleFinish(this);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.shutdownComplete = true;
                this.notifyAll();
            }
        }
    }

    private class CachedPage
    implements ICachedPageInternal {
        private final int cpid;
        private final ByteBuffer buffer;
        private final AtomicInteger pinCount;
        private final AtomicBoolean dirty;
        private final ReadWriteLock latch;
        private final Object replacementStrategyObject;
        volatile long dpid;
        CachedPage next;
        volatile boolean valid;

        public CachedPage(int cpid, ByteBuffer buffer, IPageReplacementStrategy pageReplacementStrategy) {
            this.cpid = cpid;
            this.buffer = buffer;
            this.pinCount = new AtomicInteger();
            this.dirty = new AtomicBoolean();
            this.latch = new ReentrantReadWriteLock(true);
            this.replacementStrategyObject = pageReplacementStrategy.createPerPageStrategyObject(cpid);
            this.dpid = -1L;
            this.valid = false;
        }

        public void reset(long dpid) {
            this.dpid = dpid;
            this.dirty.set(false);
            this.valid = false;
            BufferCache.this.pageReplacementStrategy.notifyCachePageReset(this);
        }

        public void invalidate() {
            this.reset(-1L);
        }

        @Override
        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        @Override
        public Object getReplacementStrategyObject() {
            return this.replacementStrategyObject;
        }

        @Override
        public boolean pinIfGoodVictim() {
            return this.pinCount.compareAndSet(0, 1);
        }

        @Override
        public int getCachedPageId() {
            return this.cpid;
        }

        @Override
        public void acquireReadLatch() {
            this.latch.readLock().lock();
        }

        @Override
        public void acquireWriteLatch() {
            this.latch.writeLock().lock();
        }

        @Override
        public void releaseReadLatch() {
            this.latch.readLock().unlock();
        }

        @Override
        public void releaseWriteLatch(boolean markDirty) {
            if (markDirty && this.dirty.compareAndSet(false, true)) {
                this.pinCount.incrementAndGet();
            }
            this.latch.writeLock().unlock();
        }
    }

    private static class CacheBucket {
        private final Lock bucketLock = new ReentrantLock();
        private CachedPage cachedPage;
    }
}

