/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.util;

import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.storage.am.common.api.IFreePageManager;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrame;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexMetaDataFrame;
import edu.uci.ics.hyracks.storage.am.common.util.TreeIndexStats;
import edu.uci.ics.hyracks.storage.common.buffercache.IBufferCache;
import edu.uci.ics.hyracks.storage.common.buffercache.ICachedPage;
import edu.uci.ics.hyracks.storage.common.file.BufferedFileHandle;

public class TreeIndexStatsGatherer {
    private final TreeIndexStats treeIndexStats = new TreeIndexStats();
    private final IBufferCache bufferCache;
    private final IFreePageManager freePageManager;
    private final int fileId;
    private final int rootPage;

    public TreeIndexStatsGatherer(IBufferCache bufferCache, IFreePageManager freePageManager, int fileId, int rootPage) {
        this.bufferCache = bufferCache;
        this.freePageManager = freePageManager;
        this.fileId = fileId;
        this.rootPage = rootPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeIndexStats gatherStats(ITreeIndexFrame leafFrame, ITreeIndexFrame interiorFrame, ITreeIndexMetaDataFrame metaFrame) throws HyracksDataException {
        this.bufferCache.openFile(this.fileId);
        this.treeIndexStats.begin();
        int maxPageId = this.freePageManager.getMaxPage(metaFrame);
        for (int pageId = 0; pageId <= maxPageId; ++pageId) {
            ICachedPage page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId), false);
            page.acquireReadLatch();
            try {
                metaFrame.setPage(page);
                leafFrame.setPage(page);
                interiorFrame.setPage(page);
                if (leafFrame.isLeaf()) {
                    if (pageId == this.rootPage) {
                        this.treeIndexStats.addRoot(leafFrame);
                        continue;
                    }
                    this.treeIndexStats.add(leafFrame);
                    continue;
                }
                if (interiorFrame.isInterior()) {
                    if (pageId == this.rootPage) {
                        this.treeIndexStats.addRoot(interiorFrame);
                        continue;
                    }
                    this.treeIndexStats.add(interiorFrame);
                    continue;
                }
                this.treeIndexStats.add(metaFrame, this.freePageManager);
                continue;
            }
            finally {
                page.releaseReadLatch();
                this.bufferCache.unpin(page);
            }
        }
        this.treeIndexStats.end();
        this.bufferCache.closeFile(this.fileId);
        return this.treeIndexStats;
    }
}

