/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.util;

import edu.uci.ics.hyracks.storage.am.common.api.IFreePageManager;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrame;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexMetaDataFrame;
import java.text.DecimalFormat;

public class TreeIndexStats {
    private TreeIndexNodeTypeStats rootStats = new TreeIndexNodeTypeStats();
    private TreeIndexNodeTypeStats interiorStats = new TreeIndexNodeTypeStats();
    private TreeIndexNodeTypeStats leafStats = new TreeIndexNodeTypeStats();
    private int freePages = 0;
    private int metaPages = 0;
    private int treeLevels = 0;

    public void begin() {
        this.rootStats.clear();
        this.interiorStats.clear();
        this.leafStats.clear();
        this.freePages = 0;
        this.metaPages = 0;
        this.treeLevels = 0;
    }

    public void addRoot(ITreeIndexFrame frame) {
        this.treeLevels = frame.getLevel() + 1;
        this.rootStats.add(frame);
    }

    public void add(ITreeIndexFrame frame) {
        if (frame.isLeaf()) {
            this.leafStats.add(frame);
        } else if (frame.isInterior()) {
            this.interiorStats.add(frame);
        }
    }

    public void add(ITreeIndexMetaDataFrame metaFrame, IFreePageManager freePageManager) {
        if (freePageManager.isFreePage(metaFrame)) {
            ++this.freePages;
        } else if (freePageManager.isMetaPage(metaFrame)) {
            ++this.metaPages;
        }
    }

    public void end() {
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        DecimalFormat df = new DecimalFormat("#####.##");
        strBuilder.append("TREE LEVELS:  " + this.treeLevels + "\n");
        strBuilder.append("FREE PAGES :  " + this.freePages + "\n");
        strBuilder.append("META PAGES :  " + this.metaPages + "\n");
        long totalPages = this.interiorStats.getNumPages() + this.leafStats.getNumPages() + (long)this.freePages + (long)this.metaPages;
        strBuilder.append("TOTAL PAGES : " + totalPages + "\n");
        strBuilder.append("\n");
        strBuilder.append("ROOT STATS\n");
        strBuilder.append("NUM TUPLES:      " + this.rootStats.getNumTuples() + "\n");
        strBuilder.append("FILL FACTOR    : " + df.format(this.rootStats.getAvgFillFactor()) + "\n");
        if (this.interiorStats.getNumPages() > 0L) {
            strBuilder.append("\n");
            strBuilder.append("INTERIOR STATS\n");
            strBuilder.append("NUM PAGES:       " + this.interiorStats.getNumPages() + "\n");
            strBuilder.append("NUM TUPLES:      " + this.interiorStats.getNumTuples() + "\n");
            strBuilder.append("AVG TUPLES/PAGE: " + df.format(this.interiorStats.getAvgNumTuples()) + "\n");
            strBuilder.append("AVG FILL FACTOR: " + df.format(this.interiorStats.getAvgFillFactor()) + "\n");
        }
        if (this.leafStats.getNumPages() > 0L) {
            strBuilder.append("\n");
            strBuilder.append("LEAF STATS\n");
            strBuilder.append("NUM PAGES:       " + df.format(this.leafStats.getNumPages()) + "\n");
            strBuilder.append("NUM TUPLES:      " + df.format(this.leafStats.getNumTuples()) + "\n");
            strBuilder.append("AVG TUPLES/PAGE: " + df.format(this.leafStats.getAvgNumTuples()) + "\n");
            strBuilder.append("AVG FILL FACTOR: " + df.format(this.leafStats.getAvgFillFactor()) + "\n");
        }
        return strBuilder.toString();
    }

    public class TreeIndexNodeTypeStats {
        private long numTuples;
        private long sumTuplesSizes;
        private long numPages;
        private double sumFillFactors;

        public void clear() {
            this.numTuples = 0L;
            this.sumTuplesSizes = 0L;
            this.numPages = 0L;
        }

        public void add(ITreeIndexFrame frame) {
            ++this.numPages;
            this.numTuples += (long)frame.getTupleCount();
            this.sumFillFactors += (double)(frame.getBuffer().capacity() - frame.getTotalFreeSpace()) / (double)frame.getBuffer().capacity();
        }

        public long getNumTuples() {
            return this.numTuples;
        }

        public long getSumTupleSizes() {
            return this.sumTuplesSizes;
        }

        public long getNumPages() {
            return this.numPages;
        }

        public double getAvgNumTuples() {
            return (double)this.numTuples / (double)this.numPages;
        }

        public double getAvgTupleSize() {
            return (double)this.sumTuplesSizes / (double)this.numTuples;
        }

        public double getAvgFillFactor() {
            return this.sumFillFactors / (double)this.numPages;
        }
    }
}

