/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.util;

import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.storage.am.common.api.IFreePageManager;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrame;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexMetaDataFrame;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.IntArrayList;
import edu.uci.ics.hyracks.storage.common.buffercache.IBufferCache;
import edu.uci.ics.hyracks.storage.common.buffercache.ICachedPage;
import edu.uci.ics.hyracks.storage.common.file.BufferedFileHandle;
import java.util.ArrayList;
import java.util.Random;

public class TreeIndexBufferCacheWarmup {
    private final IBufferCache bufferCache;
    private final IFreePageManager freePageManager;
    private final int fileId;
    private final ArrayList<IntArrayList> pagesByLevel = new ArrayList();
    private final Random rnd = new Random();

    public TreeIndexBufferCacheWarmup(IBufferCache bufferCache, IFreePageManager freePageManager, int fileId) {
        this.bufferCache = bufferCache;
        this.freePageManager = freePageManager;
        this.fileId = fileId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmup(ITreeIndexFrame frame, ITreeIndexMetaDataFrame metaFrame, int[] warmupTreeLevels, int[] warmupRepeats) throws HyracksDataException {
        this.bufferCache.openFile(this.fileId);
        int maxPageId = this.freePageManager.getMaxPage(metaFrame);
        for (int pageId = 0; pageId <= maxPageId; ++pageId) {
            ICachedPage page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId), false);
            page.acquireReadLatch();
            try {
                frame.setPage(page);
                byte level = frame.getLevel();
                while (level >= this.pagesByLevel.size()) {
                    this.pagesByLevel.add(new IntArrayList(100, 100));
                }
                if (level < 0) continue;
                this.pagesByLevel.get(level).add(pageId);
                continue;
            }
            finally {
                page.releaseReadLatch();
                this.bufferCache.unpin(page);
            }
        }
        for (int i = 0; i < warmupTreeLevels.length; ++i) {
            if (warmupTreeLevels[i] >= this.pagesByLevel.size()) continue;
            int repeats = warmupRepeats[i];
            IntArrayList pageIds = this.pagesByLevel.get(warmupTreeLevels[i]);
            int[] remainingPageIds = new int[pageIds.size()];
            for (int r = 0; r < repeats; ++r) {
                for (int j = 0; j < pageIds.size(); ++j) {
                    remainingPageIds[j] = pageIds.get(j);
                }
                int remainingLength = pageIds.size();
                for (int j = 0; j < pageIds.size(); ++j) {
                    int index = Math.abs(this.rnd.nextInt()) % remainingLength;
                    int pageId = remainingPageIds[index];
                    ICachedPage page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId), false);
                    page.acquireReadLatch();
                    page.releaseReadLatch();
                    this.bufferCache.unpin(page);
                    remainingPageIds[index] = remainingPageIds[remainingLength - 1];
                    --remainingLength;
                }
            }
        }
        this.bufferCache.closeFile(this.fileId);
    }
}

