/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HashMultiSet<E>
extends AbstractCollection<E> {
    private final Map<E, List<E>> map = new HashMap<E, List<E>>();
    private int size = 0;

    @Override
    public boolean add(E e) {
        List<E> list = this.map.get(e);
        if (list == null) {
            list = new ArrayList();
            this.map.put(e, list);
        }
        list.add(e);
        ++this.size;
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean remove(Object o) {
        List<E> list = this.map.get(o);
        if (list == null) {
            return false;
        }
        list.remove(list.size() - 1);
        if (list.isEmpty()) {
            this.map.remove(o);
        }
        --this.size;
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new HashMultiSetIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.map.clear();
        this.size = 0;
    }

    private class HashMultiSetIterator
    implements Iterator<E> {
        private Iterator<Map.Entry<E, List<E>>> mapIter;
        private Iterator<E> listIter;

        public HashMultiSetIterator() {
            this.mapIter = HashMultiSet.this.map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.mapIter.hasNext() || this.listIter != null && this.listIter.hasNext();
        }

        @Override
        public E next() {
            if (this.listIter == null || this.listIter != null && !this.listIter.hasNext()) {
                Map.Entry entry = this.mapIter.next();
                this.listIter = entry.getValue().iterator();
                return this.listIter.next();
            }
            return this.listIter.next();
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Not implemented");
        }
    }
}

