/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.tuples;

public class VarLenIntEncoderDecoder {
    public static final int ENCODE_MASK = 127;
    public static final byte CONTINUE_CHUNK = -128;
    public static final byte DECODE_MASK = 127;
    private byte[] encTmp = new byte[5];
    private int pos;
    private byte[] bytes;

    public void reset(byte[] bytes, int pos) {
        this.bytes = bytes;
        this.pos = pos;
    }

    public int encode(int val) {
        int origPos = 0;
        int tmpPos = 0;
        while (val > 127) {
            this.encTmp[tmpPos++] = (byte)(val & 0x7F);
            val >>>= 7;
        }
        this.encTmp[tmpPos++] = (byte)val;
        for (int i = 0; i < tmpPos - 1; ++i) {
            this.bytes[this.pos++] = (byte)(this.encTmp[tmpPos - 1 - i] | 0xFFFFFF80);
        }
        this.bytes[this.pos++] = this.encTmp[0];
        return this.pos - origPos;
    }

    public int decode() {
        int sum = 0;
        while ((this.bytes[this.pos] & 0xFFFFFF80) == -128) {
            sum = sum + (this.bytes[this.pos] & 0x7F) << 7;
            ++this.pos;
        }
        return sum += this.bytes[this.pos++];
    }

    public int getBytesRequired(int val) {
        int byteCount = 0;
        while (val > 127) {
            val >>>= 7;
            ++byteCount;
        }
        return byteCount + 1;
    }

    public int getPos() {
        return this.pos;
    }
}

