/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.tuples;

import edu.uci.ics.hyracks.api.dataflow.value.ITypeTraits;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrame;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import edu.uci.ics.hyracks.storage.am.common.tuples.VarLenIntEncoderDecoder;
import java.nio.ByteBuffer;

public class TypeAwareTupleReference
implements ITreeIndexTupleReference {
    protected ByteBuffer buf;
    protected int fieldStartIndex;
    protected int fieldCount;
    protected int tupleStartOff;
    protected int nullFlagsBytes;
    protected int dataStartOff;
    protected ITypeTraits[] typeTraits;
    protected VarLenIntEncoderDecoder encDec = new VarLenIntEncoderDecoder();
    protected int[] decodedFieldSlots;

    public TypeAwareTupleReference(ITypeTraits[] typeTraits) {
        this.typeTraits = typeTraits;
        this.fieldStartIndex = 0;
        this.setFieldCount(typeTraits.length);
    }

    @Override
    public void resetByTupleOffset(ByteBuffer buf, int tupleStartOff) {
        this.buf = buf;
        this.tupleStartOff = tupleStartOff;
        int field = 0;
        int cumul = 0;
        int end = this.fieldStartIndex + this.fieldCount;
        this.encDec.reset(buf.array(), tupleStartOff + this.nullFlagsBytes);
        for (int i = this.fieldStartIndex; i < end; ++i) {
            this.decodedFieldSlots[field++] = !this.typeTraits[i].isFixedLength() ? (cumul += this.encDec.decode()) : (cumul += this.typeTraits[i].getFixedLength());
        }
        this.dataStartOff = this.encDec.getPos();
    }

    @Override
    public void resetByTupleIndex(ITreeIndexFrame frame, int tupleIndex) {
        this.resetByTupleOffset(frame.getBuffer(), frame.getTupleOffset(tupleIndex));
    }

    @Override
    public void setFieldCount(int fieldCount) {
        this.fieldCount = fieldCount;
        if (this.decodedFieldSlots == null) {
            this.decodedFieldSlots = new int[fieldCount];
        } else if (fieldCount > this.decodedFieldSlots.length) {
            this.decodedFieldSlots = new int[fieldCount];
        }
        this.nullFlagsBytes = this.getNullFlagsBytes();
        this.fieldStartIndex = 0;
    }

    @Override
    public void setFieldCount(int fieldStartIndex, int fieldCount) {
        this.setFieldCount(fieldCount);
        this.fieldStartIndex = fieldStartIndex;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public byte[] getFieldData(int fIdx) {
        return this.buf.array();
    }

    public int getFieldLength(int fIdx) {
        if (fIdx == 0) {
            return this.decodedFieldSlots[0];
        }
        return this.decodedFieldSlots[fIdx] - this.decodedFieldSlots[fIdx - 1];
    }

    public int getFieldStart(int fIdx) {
        if (fIdx == 0) {
            return this.dataStartOff;
        }
        return this.dataStartOff + this.decodedFieldSlots[fIdx - 1];
    }

    protected int getNullFlagsBytes() {
        return (int)Math.ceil((double)this.fieldCount / 8.0);
    }

    @Override
    public int getTupleSize() {
        return this.dataStartOff - this.tupleStartOff + this.decodedFieldSlots[this.fieldCount - 1];
    }
}

