/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.tuples;

import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrame;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import java.nio.ByteBuffer;

public class SimpleTupleReference
implements ITreeIndexTupleReference {
    protected ByteBuffer buf;
    protected int fieldStartIndex;
    protected int fieldCount;
    protected int tupleStartOff;
    protected int nullFlagsBytes;
    protected int fieldSlotsBytes;

    @Override
    public void resetByTupleOffset(ByteBuffer buf, int tupleStartOff) {
        this.buf = buf;
        this.tupleStartOff = tupleStartOff;
    }

    @Override
    public void resetByTupleIndex(ITreeIndexFrame frame, int tupleIndex) {
        this.resetByTupleOffset(frame.getBuffer(), frame.getTupleOffset(tupleIndex));
    }

    @Override
    public void setFieldCount(int fieldCount) {
        this.fieldCount = fieldCount;
        this.nullFlagsBytes = this.getNullFlagsBytes();
        this.fieldSlotsBytes = this.getFieldSlotsBytes();
        this.fieldStartIndex = 0;
    }

    @Override
    public void setFieldCount(int fieldStartIndex, int fieldCount) {
        this.fieldCount = fieldCount;
        this.fieldStartIndex = fieldStartIndex;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public byte[] getFieldData(int fIdx) {
        return this.buf.array();
    }

    public int getFieldLength(int fIdx) {
        if (fIdx == 0) {
            return this.buf.getShort(this.tupleStartOff + this.nullFlagsBytes);
        }
        return this.buf.getShort(this.tupleStartOff + this.nullFlagsBytes + fIdx * 2) - this.buf.getShort(this.tupleStartOff + this.nullFlagsBytes + (fIdx - 1) * 2);
    }

    public int getFieldStart(int fIdx) {
        if (fIdx == 0) {
            return this.tupleStartOff + this.nullFlagsBytes + this.fieldSlotsBytes;
        }
        return this.tupleStartOff + this.nullFlagsBytes + this.fieldSlotsBytes + this.buf.getShort(this.tupleStartOff + this.nullFlagsBytes + (fIdx - 1) * 2);
    }

    protected int getNullFlagsBytes() {
        return (int)Math.ceil((double)this.fieldCount / 8.0);
    }

    protected int getFieldSlotsBytes() {
        return this.fieldCount * 2;
    }

    @Override
    public int getTupleSize() {
        return this.nullFlagsBytes + this.fieldSlotsBytes + this.buf.getShort(this.tupleStartOff + this.nullFlagsBytes + (this.fieldCount - 1) * 2);
    }
}

