/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.impls;

import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.storage.am.common.api.ICursorInitialState;
import edu.uci.ics.hyracks.storage.am.common.api.ISearchPredicate;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexCursor;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrame;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import edu.uci.ics.hyracks.storage.common.buffercache.IBufferCache;
import edu.uci.ics.hyracks.storage.common.buffercache.ICachedPage;
import edu.uci.ics.hyracks.storage.common.file.BufferedFileHandle;

public class TreeIndexDiskOrderScanCursor
implements ITreeIndexCursor {
    private int tupleIndex = 0;
    private int fileId = -1;
    private int currentPageId = -1;
    private int maxPageId = -1;
    private ICachedPage page = null;
    private IBufferCache bufferCache = null;
    private final ITreeIndexFrame frame;
    private final ITreeIndexTupleReference frameTuple;

    public TreeIndexDiskOrderScanCursor(ITreeIndexFrame frame) {
        this.frame = frame;
        this.frameTuple = frame.createTupleReference();
    }

    @Override
    public void close() throws HyracksDataException {
        this.page.releaseReadLatch();
        this.bufferCache.unpin(this.page);
        this.page = null;
    }

    @Override
    public ITreeIndexTupleReference getTuple() {
        return this.frameTuple;
    }

    @Override
    public ICachedPage getPage() {
        return this.page;
    }

    private boolean positionToNextLeaf(boolean skipCurrent) throws HyracksDataException {
        while ((this.frame.getLevel() != 0 || skipCurrent || this.frame.getTupleCount() == 0) && this.currentPageId <= this.maxPageId) {
            ++this.currentPageId;
            this.page.releaseReadLatch();
            this.bufferCache.unpin(this.page);
            ICachedPage nextPage = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.currentPageId), false);
            nextPage.acquireReadLatch();
            this.page = nextPage;
            this.frame.setPage(this.page);
            this.tupleIndex = 0;
            skipCurrent = false;
        }
        return this.currentPageId <= this.maxPageId;
    }

    @Override
    public boolean hasNext() throws HyracksDataException {
        if (this.currentPageId > this.maxPageId) {
            return false;
        }
        if (this.tupleIndex >= this.frame.getTupleCount()) {
            boolean nextLeafExists = this.positionToNextLeaf(true);
            if (nextLeafExists) {
                this.frameTuple.resetByTupleIndex(this.frame, this.tupleIndex);
                return true;
            }
            return false;
        }
        this.frameTuple.resetByTupleIndex(this.frame, this.tupleIndex);
        return true;
    }

    @Override
    public void next() throws HyracksDataException {
        ++this.tupleIndex;
    }

    @Override
    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        if (this.page != null) {
            this.page.releaseReadLatch();
            this.bufferCache.unpin(this.page);
        }
        this.page = initialState.getPage();
        this.tupleIndex = 0;
        this.frame.setPage(this.page);
        this.positionToNextLeaf(false);
    }

    @Override
    public void reset() {
        this.tupleIndex = 0;
        this.currentPageId = -1;
        this.maxPageId = -1;
        this.page = null;
    }

    @Override
    public void setBufferCache(IBufferCache bufferCache) {
        this.bufferCache = bufferCache;
    }

    @Override
    public void setFileId(int fileId) {
        this.fileId = fileId;
    }

    public void setCurrentPageId(int currentPageId) {
        this.currentPageId = currentPageId;
    }

    public void setMaxPageId(int maxPageId) {
        this.maxPageId = maxPageId;
    }

    @Override
    public boolean exclusiveLatchNodes() {
        return false;
    }

    @Override
    public void markCurrentTupleAsUpdated() throws HyracksDataException {
        throw new HyracksDataException("Updating tuples is not supported with this cursor.");
    }
}

