/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.impls;

import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.io.FileReference;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.ITupleReference;
import edu.uci.ics.hyracks.storage.am.common.api.IFreePageManager;
import edu.uci.ics.hyracks.storage.am.common.api.IIndexBulkLoader;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndex;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexAccessor;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrame;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexMetaDataFrame;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import edu.uci.ics.hyracks.storage.am.common.api.IndexException;
import edu.uci.ics.hyracks.storage.am.common.api.TreeIndexException;
import edu.uci.ics.hyracks.storage.am.common.impls.NoOpOperationCallback;
import edu.uci.ics.hyracks.storage.am.common.impls.NodeFrontier;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.MultiComparator;
import edu.uci.ics.hyracks.storage.common.buffercache.IBufferCache;
import edu.uci.ics.hyracks.storage.common.buffercache.ICachedPage;
import edu.uci.ics.hyracks.storage.common.file.BufferedFileHandle;
import edu.uci.ics.hyracks.storage.common.file.IFileMapProvider;
import java.util.ArrayList;

public abstract class AbstractTreeIndex
implements ITreeIndex {
    protected static final int rootPage = 1;
    protected final IBufferCache bufferCache;
    protected final IFileMapProvider fileMapProvider;
    protected final IFreePageManager freePageManager;
    protected final ITreeIndexFrameFactory interiorFrameFactory;
    protected final ITreeIndexFrameFactory leafFrameFactory;
    protected final IBinaryComparatorFactory[] cmpFactories;
    protected final int fieldCount;
    protected FileReference file;
    protected int fileId = -1;
    private boolean isActivated = false;

    public AbstractTreeIndex(IBufferCache bufferCache, IFileMapProvider fileMapProvider, IFreePageManager freePageManager, ITreeIndexFrameFactory interiorFrameFactory, ITreeIndexFrameFactory leafFrameFactory, IBinaryComparatorFactory[] cmpFactories, int fieldCount, FileReference file) {
        this.bufferCache = bufferCache;
        this.fileMapProvider = fileMapProvider;
        this.freePageManager = freePageManager;
        this.interiorFrameFactory = interiorFrameFactory;
        this.leafFrameFactory = leafFrameFactory;
        this.cmpFactories = cmpFactories;
        this.fieldCount = fieldCount;
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void create() throws HyracksDataException {
        if (this.isActivated) {
            throw new HyracksDataException("Failed to create the index since it is activated.");
        }
        boolean fileIsMapped = false;
        IFileMapProvider iFileMapProvider = this.fileMapProvider;
        synchronized (iFileMapProvider) {
            fileIsMapped = this.fileMapProvider.isMapped(this.file);
            if (!fileIsMapped) {
                this.bufferCache.createFile(this.file);
            }
            this.fileId = this.fileMapProvider.lookupFileId(this.file);
            try {
                this.bufferCache.openFile(this.fileId);
            }
            catch (HyracksDataException e) {
                if (!fileIsMapped) {
                    this.bufferCache.deleteFile(this.fileId, false);
                }
                throw e;
            }
        }
        this.freePageManager.open(this.fileId);
        this.initEmptyTree();
        this.freePageManager.close();
        this.bufferCache.closeFile(this.fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEmptyTree() throws HyracksDataException {
        ITreeIndexFrame frame = this.leafFrameFactory.createFrame();
        ITreeIndexMetaDataFrame metaFrame = this.freePageManager.getMetaDataFrameFactory().createFrame();
        this.freePageManager.init(metaFrame, 1);
        ICachedPage rootNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)1), true);
        rootNode.acquireWriteLatch();
        try {
            frame.setPage(rootNode);
            frame.initBuffer((byte)0);
        }
        finally {
            rootNode.releaseWriteLatch(true);
            this.bufferCache.unpin(rootNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void activate() throws HyracksDataException {
        if (this.isActivated) {
            throw new HyracksDataException("Failed to activate the index since it is already activated.");
        }
        boolean fileIsMapped = false;
        IFileMapProvider iFileMapProvider = this.fileMapProvider;
        synchronized (iFileMapProvider) {
            fileIsMapped = this.fileMapProvider.isMapped(this.file);
            if (!fileIsMapped) {
                this.bufferCache.createFile(this.file);
            }
            this.fileId = this.fileMapProvider.lookupFileId(this.file);
            try {
                this.bufferCache.openFile(this.fileId);
            }
            catch (HyracksDataException e) {
                if (!fileIsMapped) {
                    this.bufferCache.deleteFile(this.fileId, false);
                }
                throw e;
            }
        }
        this.freePageManager.open(this.fileId);
        this.isActivated = true;
    }

    @Override
    public synchronized void deactivate() throws HyracksDataException {
        if (!this.isActivated) {
            throw new HyracksDataException("Failed to deactivate the index since it is already deactivated.");
        }
        this.bufferCache.closeFile(this.fileId);
        this.freePageManager.close();
        this.isActivated = false;
    }

    @Override
    public synchronized void destroy() throws HyracksDataException {
        if (this.isActivated) {
            throw new HyracksDataException("Failed to destroy the index since it is activated.");
        }
        if (this.fileId == -1) {
            return;
        }
        this.bufferCache.deleteFile(this.fileId, false);
        this.file.delete();
        this.fileId = -1;
    }

    @Override
    public synchronized void clear() throws HyracksDataException {
        if (!this.isActivated) {
            throw new HyracksDataException("Failed to clear the index since it is not activated.");
        }
        this.initEmptyTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmptyTree(ITreeIndexFrame frame) throws HyracksDataException {
        ICachedPage rootNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)1), false);
        rootNode.acquireReadLatch();
        try {
            frame.setPage(rootNode);
            if (frame.getLevel() == 0 && frame.getTupleCount() == 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            rootNode.releaseReadLatch();
            this.bufferCache.unpin(rootNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getTreeHeight(ITreeIndexFrame frame) throws HyracksDataException {
        ICachedPage rootNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)1), false);
        rootNode.acquireReadLatch();
        try {
            frame.setPage(rootNode);
            byte by = frame.getLevel();
            return by;
        }
        finally {
            rootNode.releaseReadLatch();
            this.bufferCache.unpin(rootNode);
        }
    }

    @Override
    public int getFileId() {
        return this.fileId;
    }

    public FileReference getFileReference() {
        return this.file;
    }

    @Override
    public IBufferCache getBufferCache() {
        return this.bufferCache;
    }

    @Override
    public ITreeIndexFrameFactory getInteriorFrameFactory() {
        return this.interiorFrameFactory;
    }

    @Override
    public ITreeIndexFrameFactory getLeafFrameFactory() {
        return this.leafFrameFactory;
    }

    @Override
    public IBinaryComparatorFactory[] getComparatorFactories() {
        return this.cmpFactories;
    }

    @Override
    public IFreePageManager getFreePageManager() {
        return this.freePageManager;
    }

    @Override
    public int getRootPageId() {
        return 1;
    }

    @Override
    public int getFieldCount() {
        return this.fieldCount;
    }

    @Override
    public long getMemoryAllocationSize() {
        return 0L;
    }

    public class TreeIndexInsertBulkLoader
    implements IIndexBulkLoader {
        ITreeIndexAccessor accessor;

        public TreeIndexInsertBulkLoader() throws HyracksDataException {
            this.accessor = (ITreeIndexAccessor)AbstractTreeIndex.this.createAccessor(NoOpOperationCallback.INSTANCE, NoOpOperationCallback.INSTANCE);
        }

        @Override
        public void add(ITupleReference tuple) throws HyracksDataException {
            try {
                this.accessor.insert(tuple);
            }
            catch (IndexException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }

        @Override
        public void end() throws HyracksDataException {
        }
    }

    public abstract class AbstractTreeIndexBulkLoader
    implements IIndexBulkLoader {
        protected final MultiComparator cmp;
        protected final int slotSize;
        protected final int leafMaxBytes;
        protected final int interiorMaxBytes;
        protected final ArrayList<NodeFrontier> nodeFrontiers = new ArrayList();
        protected final ITreeIndexMetaDataFrame metaFrame;
        protected final ITreeIndexTupleWriter tupleWriter;
        protected ITreeIndexFrame leafFrame;
        protected ITreeIndexFrame interiorFrame;
        private boolean releasedLatches;

        public AbstractTreeIndexBulkLoader(float fillFactor) throws TreeIndexException, HyracksDataException {
            this.leafFrame = AbstractTreeIndex.this.leafFrameFactory.createFrame();
            this.interiorFrame = AbstractTreeIndex.this.interiorFrameFactory.createFrame();
            this.metaFrame = AbstractTreeIndex.this.freePageManager.getMetaDataFrameFactory().createFrame();
            if (!AbstractTreeIndex.this.isEmptyTree(this.leafFrame)) {
                throw new TreeIndexException("Cannot bulk-load a non-empty tree.");
            }
            this.cmp = MultiComparator.create(AbstractTreeIndex.this.cmpFactories);
            this.leafFrame.setMultiComparator(this.cmp);
            this.interiorFrame.setMultiComparator(this.cmp);
            this.tupleWriter = this.leafFrame.getTupleWriter();
            NodeFrontier leafFrontier = new NodeFrontier(this.leafFrame.createTupleReference());
            leafFrontier.pageId = AbstractTreeIndex.this.freePageManager.getFreePage(this.metaFrame);
            leafFrontier.page = AbstractTreeIndex.this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)AbstractTreeIndex.this.fileId, (int)leafFrontier.pageId), true);
            leafFrontier.page.acquireWriteLatch();
            this.interiorFrame.setPage(leafFrontier.page);
            this.interiorFrame.initBuffer((byte)0);
            this.interiorMaxBytes = (int)((float)this.interiorFrame.getBuffer().capacity() * fillFactor);
            this.leafFrame.setPage(leafFrontier.page);
            this.leafFrame.initBuffer((byte)0);
            this.leafMaxBytes = (int)((float)this.leafFrame.getBuffer().capacity() * fillFactor);
            this.slotSize = this.leafFrame.getSlotSize();
            this.nodeFrontiers.add(leafFrontier);
        }

        @Override
        public abstract void add(ITupleReference var1) throws IndexException, HyracksDataException;

        protected void handleException() throws HyracksDataException {
            for (NodeFrontier nodeFrontier : this.nodeFrontiers) {
                nodeFrontier.page.releaseWriteLatch(true);
                AbstractTreeIndex.this.bufferCache.unpin(nodeFrontier.page);
            }
            this.releasedLatches = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void end() throws HyracksDataException {
            ICachedPage newRoot = AbstractTreeIndex.this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)AbstractTreeIndex.this.fileId, (int)1), true);
            newRoot.acquireWriteLatch();
            NodeFrontier lastNodeFrontier = this.nodeFrontiers.get(this.nodeFrontiers.size() - 1);
            try {
                System.arraycopy(lastNodeFrontier.page.getBuffer().array(), 0, newRoot.getBuffer().array(), 0, lastNodeFrontier.page.getBuffer().capacity());
            }
            catch (Throwable throwable) {
                newRoot.releaseWriteLatch(true);
                AbstractTreeIndex.this.bufferCache.unpin(newRoot);
                AbstractTreeIndex.this.freePageManager.addFreePage(this.metaFrame, lastNodeFrontier.pageId);
                if (!this.releasedLatches) {
                    for (int i = 0; i < this.nodeFrontiers.size(); ++i) {
                        try {
                            this.nodeFrontiers.get((int)i).page.releaseWriteLatch(true);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        AbstractTreeIndex.this.bufferCache.unpin(this.nodeFrontiers.get((int)i).page);
                    }
                }
                throw throwable;
            }
            newRoot.releaseWriteLatch(true);
            AbstractTreeIndex.this.bufferCache.unpin(newRoot);
            AbstractTreeIndex.this.freePageManager.addFreePage(this.metaFrame, lastNodeFrontier.pageId);
            if (!this.releasedLatches) {
                for (int i = 0; i < this.nodeFrontiers.size(); ++i) {
                    try {
                        this.nodeFrontiers.get((int)i).page.releaseWriteLatch(true);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    AbstractTreeIndex.this.bufferCache.unpin(this.nodeFrontiers.get((int)i).page);
                }
            }
        }

        protected void addLevel() throws HyracksDataException {
            NodeFrontier frontier = new NodeFrontier(this.tupleWriter.createTupleReference());
            frontier.pageId = AbstractTreeIndex.this.freePageManager.getFreePage(this.metaFrame);
            frontier.page = AbstractTreeIndex.this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)AbstractTreeIndex.this.fileId, (int)frontier.pageId), true);
            frontier.page.acquireWriteLatch();
            frontier.lastTuple.setFieldCount(this.cmp.getKeyFieldCount());
            this.interiorFrame.setPage(frontier.page);
            this.interiorFrame.initBuffer((byte)this.nodeFrontiers.size());
            this.nodeFrontiers.add(frontier);
        }
    }
}

