/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.freepage;

import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.storage.am.common.api.IFreePageManager;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexMetaDataFrame;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexMetaDataFrameFactory;
import edu.uci.ics.hyracks.storage.common.buffercache.IBufferCache;
import edu.uci.ics.hyracks.storage.common.buffercache.ICachedPage;
import edu.uci.ics.hyracks.storage.common.file.BufferedFileHandle;

public class LinkedListFreePageManager
implements IFreePageManager {
    private static final byte META_PAGE_LEVEL_INDICATOR = -1;
    private static final byte FREE_PAGE_LEVEL_INDICATOR = -2;
    private final IBufferCache bufferCache;
    private final int headPage;
    private int fileId = -1;
    private final ITreeIndexMetaDataFrameFactory metaDataFrameFactory;

    public LinkedListFreePageManager(IBufferCache bufferCache, int headPage, ITreeIndexMetaDataFrameFactory metaDataFrameFactory) {
        this.bufferCache = bufferCache;
        this.headPage = headPage;
        this.metaDataFrameFactory = metaDataFrameFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFreePage(ITreeIndexMetaDataFrame metaFrame, int freePage) throws HyracksDataException {
        block10: {
            ICachedPage metaNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.headPage), false);
            metaNode.acquireWriteLatch();
            try {
                metaFrame.setPage(metaNode);
                if (metaFrame.hasSpace()) {
                    metaFrame.addFreePage(freePage);
                    break block10;
                }
                int newPage = metaFrame.getFreePage();
                if (newPage < 0) {
                    throw new Exception("Inconsistent Meta Page State. It has no space, but it also has no entries.");
                }
                ICachedPage newNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)newPage), false);
                newNode.acquireWriteLatch();
                try {
                    int metaMaxPage = metaFrame.getMaxPage();
                    System.arraycopy(metaNode.getBuffer().array(), 0, newNode.getBuffer().array(), 0, metaNode.getBuffer().capacity());
                    metaFrame.initBuffer((byte)-1);
                    metaFrame.setNextPage(newPage);
                    metaFrame.setMaxPage(metaMaxPage);
                    metaFrame.addFreePage(freePage);
                }
                finally {
                    newNode.releaseWriteLatch(true);
                    this.bufferCache.unpin(newNode);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                metaNode.releaseWriteLatch(true);
                this.bufferCache.unpin(metaNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFreePage(ITreeIndexMetaDataFrame metaFrame) throws HyracksDataException {
        int freePage;
        block9: {
            ICachedPage metaNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.headPage), false);
            metaNode.acquireWriteLatch();
            freePage = -1;
            try {
                metaFrame.setPage(metaNode);
                freePage = metaFrame.getFreePage();
                if (freePage >= 0) break block9;
                int nextPage = metaFrame.getNextPage();
                if (nextPage > 0) {
                    ICachedPage nextNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)nextPage), false);
                    nextNode.acquireWriteLatch();
                    try {
                        int maxPage = metaFrame.getMaxPage();
                        System.arraycopy(nextNode.getBuffer().array(), 0, metaNode.getBuffer().array(), 0, nextNode.getBuffer().capacity());
                        metaFrame.setMaxPage(maxPage);
                        freePage = metaFrame.getFreePage();
                        if (freePage < 0) {
                            freePage = nextPage;
                        } else {
                            metaFrame.addFreePage(nextPage);
                        }
                        break block9;
                    }
                    finally {
                        nextNode.releaseWriteLatch(true);
                        this.bufferCache.unpin(nextNode);
                    }
                }
                freePage = metaFrame.getMaxPage();
                metaFrame.setMaxPage(++freePage);
            }
            finally {
                metaNode.releaseWriteLatch(true);
                this.bufferCache.unpin(metaNode);
            }
        }
        return freePage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxPage(ITreeIndexMetaDataFrame metaFrame) throws HyracksDataException {
        ICachedPage metaNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.headPage), false);
        metaNode.acquireWriteLatch();
        int maxPage = -1;
        try {
            metaFrame.setPage(metaNode);
            maxPage = metaFrame.getMaxPage();
        }
        finally {
            metaNode.releaseWriteLatch(true);
            this.bufferCache.unpin(metaNode);
        }
        return maxPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ITreeIndexMetaDataFrame metaFrame, int currentMaxPage) throws HyracksDataException {
        ICachedPage metaNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.headPage), true);
        metaNode.acquireWriteLatch();
        try {
            metaFrame.setPage(metaNode);
            metaFrame.initBuffer((byte)-1);
            metaFrame.setMaxPage(currentMaxPage);
        }
        finally {
            metaNode.releaseWriteLatch(true);
            this.bufferCache.unpin(metaNode);
        }
    }

    @Override
    public ITreeIndexMetaDataFrameFactory getMetaDataFrameFactory() {
        return this.metaDataFrameFactory;
    }

    @Override
    public byte getFreePageLevelIndicator() {
        return -2;
    }

    @Override
    public byte getMetaPageLevelIndicator() {
        return -1;
    }

    @Override
    public boolean isFreePage(ITreeIndexMetaDataFrame metaFrame) {
        return metaFrame.getLevel() == -2;
    }

    @Override
    public boolean isMetaPage(ITreeIndexMetaDataFrame metaFrame) {
        return metaFrame.getLevel() == -1;
    }

    @Override
    public int getFirstMetadataPage() {
        return this.headPage;
    }

    @Override
    public void open(int fileId) {
        this.fileId = fileId;
    }

    @Override
    public void close() {
        this.fileId = -1;
    }
}

