/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.frames;

import edu.uci.ics.hyracks.dataflow.common.data.accessors.ITupleReference;
import edu.uci.ics.hyracks.storage.am.common.api.ISlotManager;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrame;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import edu.uci.ics.hyracks.storage.am.common.frames.FrameOpSpaceStatus;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.SlotOffTupleOff;
import edu.uci.ics.hyracks.storage.common.buffercache.ICachedPage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;

public abstract class TreeIndexNSMFrame
implements ITreeIndexFrame {
    protected static final int pageLsnOff = 0;
    protected static final int tupleCountOff = 8;
    protected static final int freeSpaceOff = 12;
    protected static final int totalFreeSpaceOff = 16;
    protected static final int levelOff = 20;
    protected static final int smFlagOff = 21;
    protected ICachedPage page = null;
    protected ByteBuffer buf = null;
    protected ISlotManager slotManager;
    protected ITreeIndexTupleWriter tupleWriter;
    protected ITreeIndexTupleReference frameTuple;

    public TreeIndexNSMFrame(ITreeIndexTupleWriter tupleWriter, ISlotManager slotManager) {
        this.tupleWriter = tupleWriter;
        this.frameTuple = tupleWriter.createTupleReference();
        this.slotManager = slotManager;
        this.slotManager.setFrame(this);
    }

    @Override
    public void initBuffer(byte level) {
        this.buf.putLong(0, 0L);
        this.buf.putInt(8, 0);
        this.resetSpaceParams();
        this.buf.put(20, level);
        this.buf.put(21, (byte)0);
    }

    @Override
    public int getMaxTupleSize(int pageSize) {
        return (pageSize - this.getPageHeaderSize()) / 2;
    }

    @Override
    public boolean isLeaf() {
        return this.buf.get(20) == 0;
    }

    @Override
    public boolean isInterior() {
        return this.buf.get(20) > 0;
    }

    @Override
    public byte getLevel() {
        return this.buf.get(20);
    }

    @Override
    public void setLevel(byte level) {
        this.buf.put(20, level);
    }

    @Override
    public int getFreeSpaceOff() {
        return this.buf.getInt(12);
    }

    @Override
    public void setFreeSpaceOff(int freeSpace) {
        this.buf.putInt(12, freeSpace);
    }

    @Override
    public void setPage(ICachedPage page) {
        this.page = page;
        this.buf = page.getBuffer();
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.page.getBuffer();
    }

    @Override
    public ICachedPage getPage() {
        return this.page;
    }

    @Override
    public boolean compact() {
        int i;
        this.resetSpaceParams();
        int tupleCount = this.buf.getInt(8);
        int freeSpace = this.buf.getInt(12);
        ArrayList<SlotOffTupleOff> sortedTupleOffs = new ArrayList<SlotOffTupleOff>();
        sortedTupleOffs.ensureCapacity(tupleCount);
        for (i = 0; i < tupleCount; ++i) {
            int slotOff = this.slotManager.getSlotOff(i);
            int tupleOff = this.slotManager.getTupleOff(slotOff);
            sortedTupleOffs.add(new SlotOffTupleOff(i, slotOff, tupleOff));
        }
        Collections.sort(sortedTupleOffs);
        for (i = 0; i < sortedTupleOffs.size(); ++i) {
            int tupleOff = ((SlotOffTupleOff)sortedTupleOffs.get((int)i)).tupleOff;
            this.frameTuple.resetByTupleOffset(this.buf, tupleOff);
            int tupleEndOff = this.frameTuple.getFieldStart(this.frameTuple.getFieldCount() - 1) + this.frameTuple.getFieldLength(this.frameTuple.getFieldCount() - 1);
            int tupleLength = tupleEndOff - tupleOff;
            System.arraycopy(this.buf.array(), tupleOff, this.buf.array(), freeSpace, tupleLength);
            this.slotManager.setSlot(((SlotOffTupleOff)sortedTupleOffs.get((int)i)).slotOff, freeSpace);
            freeSpace += tupleLength;
        }
        this.buf.putInt(12, freeSpace);
        this.buf.putInt(16, this.buf.capacity() - freeSpace - tupleCount * this.slotManager.getSlotSize());
        return false;
    }

    @Override
    public void delete(ITupleReference tuple, int tupleIndex) {
        int slotOff = this.slotManager.getSlotOff(tupleIndex);
        int tupleOff = this.slotManager.getTupleOff(slotOff);
        this.frameTuple.resetByTupleOffset(this.buf, tupleOff);
        int tupleSize = this.tupleWriter.bytesRequired(this.frameTuple);
        int slotStartOff = this.slotManager.getSlotEndOff();
        int length = slotOff - slotStartOff;
        System.arraycopy(this.buf.array(), slotStartOff, this.buf.array(), slotStartOff + this.slotManager.getSlotSize(), length);
        this.buf.putInt(8, this.buf.getInt(8) - 1);
        this.buf.putInt(16, this.buf.getInt(16) + tupleSize + this.slotManager.getSlotSize());
    }

    @Override
    public FrameOpSpaceStatus hasSpaceInsert(ITupleReference tuple) {
        int bytesRequired = this.tupleWriter.bytesRequired(tuple);
        if (bytesRequired + this.slotManager.getSlotSize() <= this.buf.capacity() - this.buf.getInt(12) - this.buf.getInt(8) * this.slotManager.getSlotSize()) {
            return FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE;
        }
        if (bytesRequired + this.slotManager.getSlotSize() <= this.buf.getInt(16)) {
            return FrameOpSpaceStatus.SUFFICIENT_SPACE;
        }
        return FrameOpSpaceStatus.INSUFFICIENT_SPACE;
    }

    @Override
    public FrameOpSpaceStatus hasSpaceUpdate(ITupleReference newTuple, int oldTupleIndex) {
        this.frameTuple.resetByTupleIndex(this, oldTupleIndex);
        int oldTupleBytes = this.frameTuple.getTupleSize();
        int newTupleBytes = this.tupleWriter.bytesRequired(newTuple);
        int additionalBytesRequired = newTupleBytes - oldTupleBytes;
        if (additionalBytesRequired <= 0) {
            return FrameOpSpaceStatus.SUFFICIENT_INPLACE_SPACE;
        }
        if (newTupleBytes <= this.buf.capacity() - this.buf.getInt(12) - this.buf.getInt(8) * this.slotManager.getSlotSize()) {
            return FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE;
        }
        if (additionalBytesRequired <= this.buf.getInt(16)) {
            return FrameOpSpaceStatus.SUFFICIENT_SPACE;
        }
        return FrameOpSpaceStatus.INSUFFICIENT_SPACE;
    }

    protected void resetSpaceParams() {
        this.buf.putInt(12, 22);
        this.buf.putInt(16, this.buf.capacity() - 22);
    }

    @Override
    public void insert(ITupleReference tuple, int tupleIndex) {
        this.slotManager.insertSlot(tupleIndex, this.buf.getInt(12));
        int bytesWritten = this.tupleWriter.writeTuple(tuple, this.buf.array(), this.buf.getInt(12));
        this.buf.putInt(8, this.buf.getInt(8) + 1);
        this.buf.putInt(12, this.buf.getInt(12) + bytesWritten);
        this.buf.putInt(16, this.buf.getInt(16) - bytesWritten - this.slotManager.getSlotSize());
    }

    @Override
    public void update(ITupleReference newTuple, int oldTupleIndex, boolean inPlace) {
        this.frameTuple.resetByTupleIndex(this, oldTupleIndex);
        int oldTupleBytes = this.frameTuple.getTupleSize();
        int slotOff = this.slotManager.getSlotOff(oldTupleIndex);
        int bytesWritten = 0;
        if (inPlace) {
            bytesWritten = this.tupleWriter.writeTuple(newTuple, this.buf.array(), this.buf.getInt(slotOff));
        } else {
            int newTupleOff = this.buf.getInt(12);
            bytesWritten = this.tupleWriter.writeTuple(newTuple, this.buf.array(), newTupleOff);
            this.buf.putInt(slotOff, newTupleOff);
            this.buf.putInt(12, newTupleOff + bytesWritten);
        }
        this.buf.putInt(16, this.buf.getInt(16) + oldTupleBytes - bytesWritten);
    }

    @Override
    public String printHeader() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("pageLsnOff:        0\n");
        strBuilder.append("tupleCountOff:     8\n");
        strBuilder.append("freeSpaceOff:      12\n");
        strBuilder.append("totalFreeSpaceOff: 16\n");
        strBuilder.append("levelOff:          20\n");
        strBuilder.append("smFlagOff:         21\n");
        return strBuilder.toString();
    }

    @Override
    public int getTupleCount() {
        return this.buf.getInt(8);
    }

    @Override
    public ISlotManager getSlotManager() {
        return this.slotManager;
    }

    @Override
    public int getTupleOffset(int slotNum) {
        return this.slotManager.getTupleOff(this.slotManager.getSlotStartOff() - slotNum * this.slotManager.getSlotSize());
    }

    @Override
    public long getPageLsn() {
        return this.buf.getLong(0);
    }

    @Override
    public void setPageLsn(long pageLsn) {
        this.buf.putLong(0, pageLsn);
    }

    @Override
    public int getTotalFreeSpace() {
        return this.buf.getInt(16);
    }

    @Override
    public boolean compress() {
        return false;
    }

    @Override
    public int getSlotSize() {
        return this.slotManager.getSlotSize();
    }

    @Override
    public ITreeIndexTupleWriter getTupleWriter() {
        return this.tupleWriter;
    }

    @Override
    public ITreeIndexTupleReference createTupleReference() {
        return this.tupleWriter.createTupleReference();
    }

    public int getFreeContiguousSpace() {
        return this.buf.capacity() - this.getFreeSpaceOff() - this.getTupleCount() * this.slotManager.getSlotSize();
    }
}

