/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.frames;

import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexMetaDataFrame;
import edu.uci.ics.hyracks.storage.common.buffercache.ICachedPage;
import java.nio.ByteBuffer;

public class LIFOMetaDataFrame
implements ITreeIndexMetaDataFrame {
    protected static final int MAGIC_VALID_INT = 1540483477;
    protected static final int tupleCountOff = 0;
    protected static final int freeSpaceOff = 4;
    protected static final int maxPageOff = 8;
    protected static final int levelOff = 20;
    protected static final int nextPageOff = 21;
    protected static final int validOff = 25;
    protected static final int lsnOff = 29;
    protected ICachedPage page = null;
    protected ByteBuffer buf = null;

    @Override
    public int getMaxPage() {
        return this.buf.getInt(8);
    }

    @Override
    public void setMaxPage(int maxPage) {
        this.buf.putInt(8, maxPage);
    }

    @Override
    public int getFreePage() {
        int tupleCount = this.buf.getInt(0);
        if (tupleCount > 0) {
            int lastPageOff = this.buf.getInt(4) - 4;
            this.buf.putInt(4, lastPageOff);
            this.buf.putInt(0, tupleCount - 1);
            return this.buf.getInt(lastPageOff);
        }
        return -1;
    }

    @Override
    public boolean hasSpace() {
        return this.buf.getInt(4) + 4 < this.buf.capacity();
    }

    @Override
    public void addFreePage(int freePage) {
        int freeSpace = this.buf.getInt(4);
        this.buf.putInt(freeSpace, freePage);
        this.buf.putInt(4, freeSpace + 4);
        this.buf.putInt(0, this.buf.getInt(0) + 1);
    }

    @Override
    public byte getLevel() {
        return this.buf.get(20);
    }

    @Override
    public void setLevel(byte level) {
        this.buf.put(20, level);
    }

    @Override
    public ICachedPage getPage() {
        return this.page;
    }

    @Override
    public void setPage(ICachedPage page) {
        this.page = page;
        this.buf = page.getBuffer();
    }

    @Override
    public void initBuffer(byte level) {
        this.buf.putInt(0, 0);
        this.buf.putInt(4, 33);
        this.buf.put(20, level);
        this.buf.putInt(21, -1);
        this.setValid(false);
    }

    @Override
    public int getNextPage() {
        return this.buf.getInt(21);
    }

    @Override
    public void setNextPage(int nextPage) {
        this.buf.putInt(21, nextPage);
    }

    @Override
    public boolean isValid() {
        return this.buf.getInt(25) == 1540483477;
    }

    @Override
    public void setValid(boolean isValid) {
        if (isValid) {
            this.buf.putInt(25, 1540483477);
        } else {
            this.buf.putInt(25, 0);
        }
    }

    @Override
    public long getLSN() {
        return this.buf.getLong(29);
    }

    @Override
    public void setLSN(long lsn) {
        this.buf.putLong(29, lsn);
    }
}

