/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.frames;

import edu.uci.ics.hyracks.storage.am.common.api.ISlotManager;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrame;

public abstract class AbstractSlotManager
implements ISlotManager {
    protected final int GREATEST_KEY_INDICATOR = -1;
    protected final int ERROR_INDICATOR = -2;
    protected static final int slotSize = 4;
    protected ITreeIndexFrame frame;

    @Override
    public int getTupleOff(int offset) {
        return this.frame.getBuffer().getInt(offset);
    }

    @Override
    public void setSlot(int offset, int value) {
        this.frame.getBuffer().putInt(offset, value);
    }

    @Override
    public int getSlotEndOff() {
        return this.frame.getBuffer().capacity() - this.frame.getTupleCount() * 4;
    }

    @Override
    public int getSlotStartOff() {
        return this.frame.getBuffer().capacity() - 4;
    }

    @Override
    public int getSlotSize() {
        return 4;
    }

    @Override
    public void setFrame(ITreeIndexFrame frame) {
        this.frame = frame;
    }

    @Override
    public int getSlotOff(int tupleIndex) {
        return this.getSlotStartOff() - tupleIndex * 4;
    }

    @Override
    public int getGreatestKeyIndicator() {
        return -1;
    }

    @Override
    public int getErrorIndicator() {
        return -2;
    }
}

