/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.datagen;

import edu.uci.ics.hyracks.api.dataflow.value.ISerializerDeserializer;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.ITupleReference;
import edu.uci.ics.hyracks.storage.am.common.datagen.IFieldValueGenerator;
import java.io.DataOutput;
import java.io.IOException;

public class TupleGenerator {
    protected final ISerializerDeserializer[] fieldSerdes;
    protected final IFieldValueGenerator[] fieldGens;
    protected final ArrayTupleBuilder tb;
    protected final ArrayTupleReference tuple;
    protected final byte[] payload;
    protected final DataOutput tbDos;

    public TupleGenerator(IFieldValueGenerator[] fieldGens, ISerializerDeserializer[] fieldSerdes, int payloadSize) {
        this.fieldSerdes = fieldSerdes;
        this.fieldGens = fieldGens;
        this.tuple = new ArrayTupleReference();
        if (payloadSize > 0) {
            this.tb = new ArrayTupleBuilder(fieldSerdes.length + 1);
            this.payload = new byte[payloadSize];
        } else {
            this.tb = new ArrayTupleBuilder(fieldSerdes.length);
            this.payload = null;
        }
        this.tbDos = this.tb.getDataOutput();
    }

    public ITupleReference next() throws IOException {
        this.tb.reset();
        for (int i = 0; i < this.fieldSerdes.length; ++i) {
            this.fieldSerdes[i].serialize(this.fieldGens[i].next(), this.tbDos);
            this.tb.addFieldEndOffset();
        }
        if (this.payload != null) {
            this.tbDos.write(this.payload);
            this.tb.addFieldEndOffset();
        }
        this.tuple.reset(this.tb.getFieldEndOffsets(), this.tb.getByteArray());
        return this.tuple;
    }

    public ITupleReference get() {
        return this.tuple;
    }

    public void reset() {
        for (IFieldValueGenerator fieldGen : this.fieldGens) {
            fieldGen.reset();
        }
    }

    public ISerializerDeserializer[] getFieldSerdes() {
        return this.fieldSerdes;
    }

    public IFieldValueGenerator[] getFieldGens() {
        return this.fieldGens;
    }
}

