/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.datagen;

import java.util.Arrays;

public class ProbabilityHelper {
    public static double[] getUniformProbDist(int numChoices) {
        double[] probDist = new double[numChoices];
        for (int i = 0; i < numChoices; ++i) {
            probDist[i] = 1.0 / (double)numChoices;
        }
        return probDist;
    }

    public static double[] getZipfProbDist(int numChoices, int zipfSkew) {
        int i;
        double[] probDist = new double[numChoices];
        double divisor = 0.0;
        for (i = 1; i <= numChoices; ++i) {
            divisor += 1.0 / Math.pow(i, zipfSkew);
        }
        for (i = 1; i <= numChoices; ++i) {
            probDist[i - 1] = 1.0 / Math.pow(i, zipfSkew) / divisor;
        }
        return probDist;
    }

    public static int[] getCumulIntRanges(double[] probDist) {
        int[] opRanges = new int[probDist.length];
        if (opRanges.length > 1) {
            opRanges[0] = (int)Math.floor(2.147483647E9 * probDist[0]);
            for (int i = 1; i < opRanges.length - 1; ++i) {
                opRanges[i] = opRanges[i - 1] + (int)Math.floor(2.147483647E9 * probDist[i]);
            }
            opRanges[opRanges.length - 1] = Integer.MAX_VALUE;
        } else {
            opRanges[0] = Integer.MAX_VALUE;
        }
        return opRanges;
    }

    public static int choose(int[] cumulIntRanges, int randomInt) {
        int rndVal = Math.abs(randomInt);
        int ix = Arrays.binarySearch(cumulIntRanges, rndVal);
        if (ix < 0) {
            ix = -ix - 1;
        }
        return ix;
    }
}

