/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.datagen;

import edu.uci.ics.hyracks.storage.am.common.datagen.IFieldValueGenerator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class PersonNameFieldValueGenerator
implements IFieldValueGenerator<String> {
    private final String FIRST_NAMES_FILE = "dist.all.first.cleaned";
    private final String LAST_NAMES_FILE = "dist.all.last.cleaned";
    private final Random rnd;
    private final double middleInitialProb;
    private final String letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private List<String> firstNames = new ArrayList<String>();
    private List<String> lastNames = new ArrayList<String>();

    public PersonNameFieldValueGenerator(Random rnd, double middleInitialProb) throws IOException {
        this.rnd = rnd;
        this.middleInitialProb = middleInitialProb;
        this.initNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initNames() throws IOException {
        String line;
        InputStream firstNamesIn = this.getClass().getClassLoader().getResourceAsStream("dist.all.first.cleaned");
        try (BufferedReader firstNamesReader = new BufferedReader(new InputStreamReader(firstNamesIn));){
            while ((line = firstNamesReader.readLine()) != null) {
                this.firstNames.add(line.trim());
            }
        }
        InputStream lastNamesIn = this.getClass().getClassLoader().getResourceAsStream("dist.all.last.cleaned");
        try (BufferedReader lastNamesReader = new BufferedReader(new InputStreamReader(lastNamesIn));){
            while ((line = lastNamesReader.readLine()) != null) {
                this.lastNames.add(line.trim());
            }
        }
    }

    @Override
    public String next() {
        StringBuilder strBuilder = new StringBuilder();
        int fix = Math.abs(this.rnd.nextInt()) % this.firstNames.size();
        strBuilder.append(this.firstNames.get(fix));
        strBuilder.append(" ");
        double d = Math.abs(this.rnd.nextDouble());
        if (d <= this.middleInitialProb) {
            int mix = Math.abs(this.rnd.nextInt()) % "ABCDEFGHIJKLMNOPQRSTUVWXYZ".length();
            strBuilder.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(mix));
            strBuilder.append(". ");
        }
        int lix = Math.abs(this.rnd.nextInt()) % this.lastNames.size();
        strBuilder.append(this.lastNames.get(lix));
        return strBuilder.toString();
    }

    @Override
    public void reset() {
    }
}

