/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.datagen;

import edu.uci.ics.hyracks.api.dataflow.value.ISerializerDeserializer;
import edu.uci.ics.hyracks.dataflow.common.data.marshalling.DoubleSerializerDeserializer;
import edu.uci.ics.hyracks.dataflow.common.data.marshalling.FloatSerializerDeserializer;
import edu.uci.ics.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import edu.uci.ics.hyracks.dataflow.common.data.marshalling.UTF8StringSerializerDeserializer;
import edu.uci.ics.hyracks.storage.am.common.datagen.DoubleFieldValueGenerator;
import edu.uci.ics.hyracks.storage.am.common.datagen.FloatFieldValueGenerator;
import edu.uci.ics.hyracks.storage.am.common.datagen.IFieldValueGenerator;
import edu.uci.ics.hyracks.storage.am.common.datagen.IntegerFieldValueGenerator;
import edu.uci.ics.hyracks.storage.am.common.datagen.SortedDoubleFieldValueGenerator;
import edu.uci.ics.hyracks.storage.am.common.datagen.SortedFloatFieldValueGenerator;
import edu.uci.ics.hyracks.storage.am.common.datagen.SortedIntegerFieldValueGenerator;
import edu.uci.ics.hyracks.storage.am.common.datagen.StringFieldValueGenerator;
import java.util.Random;

public class DataGenUtils {
    public static IFieldValueGenerator getFieldGenFromSerde(ISerializerDeserializer serde, Random rnd, boolean sorted) {
        if (serde instanceof IntegerSerializerDeserializer) {
            if (sorted) {
                return new SortedIntegerFieldValueGenerator();
            }
            return new IntegerFieldValueGenerator(rnd);
        }
        if (serde instanceof FloatSerializerDeserializer) {
            if (sorted) {
                return new SortedFloatFieldValueGenerator();
            }
            return new FloatFieldValueGenerator(rnd);
        }
        if (serde instanceof DoubleSerializerDeserializer) {
            if (sorted) {
                return new SortedDoubleFieldValueGenerator();
            }
            return new DoubleFieldValueGenerator(rnd);
        }
        if (serde instanceof UTF8StringSerializerDeserializer) {
            return new StringFieldValueGenerator(20, rnd);
        }
        return null;
    }

    public static IFieldValueGenerator[] getFieldGensFromSerdes(ISerializerDeserializer[] serdes, Random rnd, boolean sorted) {
        IFieldValueGenerator[] fieldValueGens = new IFieldValueGenerator[serdes.length];
        for (int i = 0; i < serdes.length; ++i) {
            fieldValueGens[i] = DataGenUtils.getFieldGenFromSerde(serdes[i], rnd, sorted);
        }
        return fieldValueGens;
    }
}

