/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.datagen;

import edu.uci.ics.hyracks.api.dataflow.value.ISerializerDeserializer;
import edu.uci.ics.hyracks.storage.am.common.datagen.DataGenUtils;
import edu.uci.ics.hyracks.storage.am.common.datagen.IFieldValueGenerator;
import edu.uci.ics.hyracks.storage.am.common.datagen.TupleBatch;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class DataGenThread
extends Thread {
    public final BlockingQueue<TupleBatch> tupleBatchQueue;
    private final int maxNumBatches;
    private final int maxOutstandingBatches;
    private int numBatches = 0;
    private final Random rnd;
    private TupleBatch[] tupleBatches;
    private int ringPos;

    public DataGenThread(int numConsumers, int maxNumBatches, int batchSize, ISerializerDeserializer[] fieldSerdes, int payloadSize, int rndSeed, int maxOutstandingBatches, boolean sorted) {
        this.maxNumBatches = maxNumBatches;
        this.maxOutstandingBatches = maxOutstandingBatches;
        this.rnd = new Random(rndSeed);
        this.tupleBatches = new TupleBatch[maxOutstandingBatches];
        IFieldValueGenerator[] fieldGens = DataGenUtils.getFieldGensFromSerdes(fieldSerdes, this.rnd, sorted);
        for (int i = 0; i < maxOutstandingBatches; ++i) {
            this.tupleBatches[i] = new TupleBatch(batchSize, fieldGens, fieldSerdes, payloadSize);
        }
        this.tupleBatchQueue = new LinkedBlockingQueue<TupleBatch>(maxOutstandingBatches);
        this.ringPos = 0;
    }

    public DataGenThread(int numConsumers, int maxNumBatches, int batchSize, ISerializerDeserializer[] fieldSerdes, IFieldValueGenerator[] fieldGens, int rndSeed, int maxOutstandingBatches) {
        this.maxNumBatches = maxNumBatches;
        this.maxOutstandingBatches = maxOutstandingBatches;
        this.rnd = new Random(rndSeed);
        this.tupleBatches = new TupleBatch[maxOutstandingBatches];
        for (int i = 0; i < maxOutstandingBatches; ++i) {
            this.tupleBatches[i] = new TupleBatch(batchSize, fieldGens, fieldSerdes, 0);
        }
        this.tupleBatchQueue = new LinkedBlockingQueue<TupleBatch>(maxOutstandingBatches);
        this.ringPos = 0;
    }

    @Override
    public void run() {
        while (this.numBatches < this.maxNumBatches) {
            boolean added = false;
            try {
                if (this.tupleBatches[this.ringPos].inUse.compareAndSet(false, true)) {
                    this.tupleBatches[this.ringPos].generate();
                    this.tupleBatchQueue.put(this.tupleBatches[this.ringPos]);
                    added = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!added) continue;
            ++this.numBatches;
            ++this.ringPos;
            if (this.ringPos < this.maxOutstandingBatches) continue;
            this.ringPos = 0;
        }
    }

    public TupleBatch getBatch() throws InterruptedException {
        return this.tupleBatchQueue.take();
    }

    public void releaseBatch(TupleBatch batch) {
        batch.inUse.set(false);
    }
}

