/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.dataflow;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.common.data.marshalling.UTF8StringSerializerDeserializer;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndex;
import edu.uci.ics.hyracks.storage.am.common.dataflow.AbstractTreeIndexOperatorDescriptor;
import edu.uci.ics.hyracks.storage.am.common.dataflow.TreeIndexDataflowHelper;
import edu.uci.ics.hyracks.storage.am.common.util.TreeIndexStats;
import edu.uci.ics.hyracks.storage.am.common.util.TreeIndexStatsGatherer;
import edu.uci.ics.hyracks.storage.common.buffercache.IBufferCache;
import edu.uci.ics.hyracks.storage.common.file.IFileMapProvider;
import java.io.DataOutput;
import java.nio.ByteBuffer;

public class TreeIndexStatsOperatorNodePushable
extends AbstractUnaryOutputSourceOperatorNodePushable {
    private final AbstractTreeIndexOperatorDescriptor opDesc;
    private final IHyracksTaskContext ctx;
    private final TreeIndexDataflowHelper treeIndexHelper;
    private TreeIndexStatsGatherer statsGatherer;

    public TreeIndexStatsOperatorNodePushable(AbstractTreeIndexOperatorDescriptor opDesc, IHyracksTaskContext ctx, int partition) {
        this.opDesc = opDesc;
        this.ctx = ctx;
        this.treeIndexHelper = (TreeIndexDataflowHelper)opDesc.getIndexDataflowHelperFactory().createIndexDataflowHelper(opDesc, ctx, partition);
    }

    public void deinitialize() throws HyracksDataException {
    }

    public IFrameWriter getInputFrameWriter(int index) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws HyracksDataException {
        this.treeIndexHelper.open();
        ITreeIndex treeIndex = (ITreeIndex)this.treeIndexHelper.getIndexInstance();
        try {
            this.writer.open();
            IBufferCache bufferCache = this.opDesc.getStorageManager().getBufferCache(this.ctx);
            IFileMapProvider fileMapProvider = this.opDesc.getStorageManager().getFileMapProvider(this.ctx);
            int indexFileId = fileMapProvider.lookupFileId(this.treeIndexHelper.getFileReference());
            this.statsGatherer = new TreeIndexStatsGatherer(bufferCache, treeIndex.getFreePageManager(), indexFileId, treeIndex.getRootPageId());
            TreeIndexStats stats = this.statsGatherer.gatherStats(treeIndex.getLeafFrameFactory().createFrame(), treeIndex.getInteriorFrameFactory().createFrame(), treeIndex.getFreePageManager().getMetaDataFrameFactory().createFrame());
            ByteBuffer frame = this.ctx.allocateFrame();
            FrameTupleAppender appender = new FrameTupleAppender(this.ctx.getFrameSize());
            appender.reset(frame, true);
            ArrayTupleBuilder tb = new ArrayTupleBuilder(1);
            DataOutput dos = tb.getDataOutput();
            tb.reset();
            UTF8StringSerializerDeserializer.INSTANCE.serialize(stats.toString(), dos);
            tb.addFieldEndOffset();
            if (!appender.append(tb.getFieldEndOffsets(), tb.getByteArray(), 0, tb.getSize())) {
                throw new HyracksDataException("Record size (" + tb.getSize() + ") larger than frame size (" + appender.getBuffer().capacity() + ")");
            }
            FrameUtils.flushFrame((ByteBuffer)frame, (IFrameWriter)this.writer);
        }
        catch (Exception e) {
            this.writer.fail();
        }
        finally {
            this.writer.close();
            this.treeIndexHelper.close();
        }
    }
}

