/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.dataflow;

import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.ITupleReference;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import edu.uci.ics.hyracks.storage.am.common.api.ISearchOperationCallback;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndex;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexAccessor;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexCursor;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrame;
import edu.uci.ics.hyracks.storage.am.common.dataflow.AbstractTreeIndexOperatorDescriptor;
import edu.uci.ics.hyracks.storage.am.common.dataflow.TreeIndexDataflowHelper;
import edu.uci.ics.hyracks.storage.am.common.impls.NoOpOperationCallback;
import java.io.DataOutput;
import java.nio.ByteBuffer;

public class TreeIndexDiskOrderScanOperatorNodePushable
extends AbstractUnaryOutputSourceOperatorNodePushable {
    private final AbstractTreeIndexOperatorDescriptor opDesc;
    private final IHyracksTaskContext ctx;
    private final TreeIndexDataflowHelper treeIndexHelper;
    private ITreeIndex treeIndex;

    public TreeIndexDiskOrderScanOperatorNodePushable(AbstractTreeIndexOperatorDescriptor opDesc, IHyracksTaskContext ctx, int partition) {
        this.opDesc = opDesc;
        this.ctx = ctx;
        this.treeIndexHelper = (TreeIndexDataflowHelper)opDesc.getIndexDataflowHelperFactory().createIndexDataflowHelper(opDesc, ctx, partition);
    }

    public void initialize() throws HyracksDataException {
        this.treeIndexHelper.open();
        this.treeIndex = (ITreeIndex)this.treeIndexHelper.getIndexInstance();
        try {
            ITreeIndexFrame cursorFrame = this.treeIndex.getLeafFrameFactory().createFrame();
            ITreeIndexCursor cursor = this.treeIndexHelper.createDiskOrderScanCursor(cursorFrame);
            ISearchOperationCallback searchCallback = this.opDesc.getSearchOpCallbackFactory().createSearchOperationCallback(this.treeIndexHelper.getResourceID(), this.ctx);
            ITreeIndexAccessor indexAccessor = (ITreeIndexAccessor)this.treeIndex.createAccessor(NoOpOperationCallback.INSTANCE, searchCallback);
            this.writer.open();
            try {
                indexAccessor.diskOrderScan(cursor);
                int fieldCount = this.treeIndex.getFieldCount();
                ByteBuffer frame = this.ctx.allocateFrame();
                FrameTupleAppender appender = new FrameTupleAppender(this.ctx.getFrameSize());
                appender.reset(frame, true);
                ArrayTupleBuilder tb = new ArrayTupleBuilder(fieldCount);
                DataOutput dos = tb.getDataOutput();
                while (cursor.hasNext()) {
                    tb.reset();
                    cursor.next();
                    ITupleReference frameTuple = cursor.getTuple();
                    for (int i = 0; i < frameTuple.getFieldCount(); ++i) {
                        dos.write(frameTuple.getFieldData(i), frameTuple.getFieldStart(i), frameTuple.getFieldLength(i));
                        tb.addFieldEndOffset();
                    }
                    if (appender.append(tb.getFieldEndOffsets(), tb.getByteArray(), 0, tb.getSize())) continue;
                    FrameUtils.flushFrame((ByteBuffer)frame, (IFrameWriter)this.writer);
                    appender.reset(frame, true);
                    if (appender.append(tb.getFieldEndOffsets(), tb.getByteArray(), 0, tb.getSize())) continue;
                    throw new HyracksDataException("Record size (" + tb.getSize() + ") larger than frame size (" + appender.getBuffer().capacity() + ")");
                }
                if (appender.getTupleCount() > 0) {
                    FrameUtils.flushFrame((ByteBuffer)frame, (IFrameWriter)this.writer);
                }
            }
            catch (Exception e) {
                this.writer.fail();
                throw new HyracksDataException((Throwable)e);
            }
            finally {
                cursor.close();
                this.writer.close();
            }
        }
        catch (Exception e) {
            this.treeIndexHelper.close();
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void deinitialize() throws HyracksDataException {
        this.treeIndexHelper.close();
    }
}

