/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.dataflow;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.comm.IFrameWriter;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.api.dataflow.value.RecordDescriptor;
import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import edu.uci.ics.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import edu.uci.ics.hyracks.dataflow.common.comm.util.FrameUtils;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.ITupleReference;
import edu.uci.ics.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import edu.uci.ics.hyracks.storage.am.common.api.IIndex;
import edu.uci.ics.hyracks.storage.am.common.api.IIndexAccessor;
import edu.uci.ics.hyracks.storage.am.common.api.IIndexCursor;
import edu.uci.ics.hyracks.storage.am.common.api.IIndexDataflowHelper;
import edu.uci.ics.hyracks.storage.am.common.api.ISearchOperationCallback;
import edu.uci.ics.hyracks.storage.am.common.api.ISearchPredicate;
import edu.uci.ics.hyracks.storage.am.common.dataflow.IIndexOperatorDescriptor;
import edu.uci.ics.hyracks.storage.am.common.impls.NoOpOperationCallback;
import java.io.DataOutput;
import java.nio.ByteBuffer;

public abstract class IndexSearchOperatorNodePushable
extends AbstractUnaryInputUnaryOutputOperatorNodePushable {
    protected final IIndexOperatorDescriptor opDesc;
    protected final IHyracksTaskContext ctx;
    protected final IIndexDataflowHelper indexHelper;
    protected FrameTupleAccessor accessor;
    protected ByteBuffer writeBuffer;
    protected FrameTupleAppender appender;
    protected ArrayTupleBuilder tb;
    protected DataOutput dos;
    protected IIndex index;
    protected ISearchPredicate searchPred;
    protected IIndexCursor cursor;
    protected IIndexAccessor indexAccessor;
    protected final RecordDescriptor inputRecDesc;
    protected final boolean retainInput;
    protected FrameTupleReference frameTuple;

    public IndexSearchOperatorNodePushable(IIndexOperatorDescriptor opDesc, IHyracksTaskContext ctx, int partition, IRecordDescriptorProvider recordDescProvider) {
        this.opDesc = opDesc;
        this.ctx = ctx;
        this.indexHelper = opDesc.getIndexDataflowHelperFactory().createIndexDataflowHelper(opDesc, ctx, partition);
        this.retainInput = opDesc.getRetainInput();
        this.inputRecDesc = recordDescProvider.getInputRecordDescriptor(opDesc.getActivityId(), 0);
    }

    protected abstract ISearchPredicate createSearchPredicate();

    protected abstract void resetSearchPredicate(int var1);

    protected IIndexCursor createCursor() {
        return this.indexAccessor.createSearchCursor(false);
    }

    public void open() throws HyracksDataException {
        this.accessor = new FrameTupleAccessor(this.ctx.getFrameSize(), this.inputRecDesc);
        this.writer.open();
        this.indexHelper.open();
        this.index = this.indexHelper.getIndexInstance();
        try {
            this.searchPred = this.createSearchPredicate();
            this.writeBuffer = this.ctx.allocateFrame();
            this.tb = new ArrayTupleBuilder(this.recordDesc.getFieldCount());
            this.dos = this.tb.getDataOutput();
            this.appender = new FrameTupleAppender(this.ctx.getFrameSize());
            this.appender.reset(this.writeBuffer, true);
            ISearchOperationCallback searchCallback = this.opDesc.getSearchOpCallbackFactory().createSearchOperationCallback(this.indexHelper.getResourceID(), this.ctx);
            this.indexAccessor = this.index.createAccessor(NoOpOperationCallback.INSTANCE, searchCallback);
            this.cursor = this.createCursor();
            if (this.retainInput) {
                this.frameTuple = new FrameTupleReference();
            }
        }
        catch (Exception e) {
            this.indexHelper.close();
            throw new HyracksDataException((Throwable)e);
        }
    }

    protected void writeSearchResults(int tupleIndex) throws Exception {
        while (this.cursor.hasNext()) {
            this.tb.reset();
            this.cursor.next();
            if (this.retainInput) {
                this.frameTuple.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
                for (int i = 0; i < this.frameTuple.getFieldCount(); ++i) {
                    this.dos.write(this.frameTuple.getFieldData(i), this.frameTuple.getFieldStart(i), this.frameTuple.getFieldLength(i));
                    this.tb.addFieldEndOffset();
                }
            }
            ITupleReference tuple = this.cursor.getTuple();
            for (int i = 0; i < tuple.getFieldCount(); ++i) {
                this.dos.write(tuple.getFieldData(i), tuple.getFieldStart(i), tuple.getFieldLength(i));
                this.tb.addFieldEndOffset();
            }
            if (this.appender.append(this.tb.getFieldEndOffsets(), this.tb.getByteArray(), 0, this.tb.getSize())) continue;
            FrameUtils.flushFrame((ByteBuffer)this.writeBuffer, (IFrameWriter)this.writer);
            this.appender.reset(this.writeBuffer, true);
            if (this.appender.append(this.tb.getFieldEndOffsets(), this.tb.getByteArray(), 0, this.tb.getSize())) continue;
            throw new HyracksDataException("Record size (" + this.tb.getSize() + ") larger than frame size (" + this.appender.getBuffer().capacity() + ")");
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        try {
            for (int i = 0; i < tupleCount; ++i) {
                this.resetSearchPredicate(i);
                this.cursor.reset();
                this.indexAccessor.search(this.cursor, this.searchPred);
                this.writeSearchResults(i);
            }
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws HyracksDataException {
        try {
            if (this.appender.getTupleCount() > 0) {
                FrameUtils.flushFrame((ByteBuffer)this.writeBuffer, (IFrameWriter)this.writer);
            }
            this.writer.close();
            try {
                this.cursor.close();
            }
            catch (Exception e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        finally {
            this.indexHelper.close();
        }
    }

    public void fail() throws HyracksDataException {
        this.writer.fail();
    }
}

