/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.common.dataflow;

import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.api.lifecycle.ILifeCycleComponent;
import edu.uci.ics.hyracks.storage.am.common.api.IIndex;
import edu.uci.ics.hyracks.storage.am.common.api.IIndexLifecycleManager;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndexLifecycleManager
implements IIndexLifecycleManager,
ILifeCycleComponent {
    private static final long DEFAULT_MEMORY_BUDGET = 0x6400000L;
    private final Map<Long, IndexInfo> indexInfos = new HashMap<Long, IndexInfo>();
    private final long memoryBudget;
    private long memoryUsed;

    public IndexLifecycleManager() {
        this(0x6400000L);
    }

    public IndexLifecycleManager(long memoryBudget) {
        this.memoryBudget = memoryBudget;
        this.memoryUsed = 0L;
    }

    private boolean evictCandidateIndex() throws HyracksDataException {
        IndexInfo info = Collections.min(this.indexInfos.values());
        if (info.referenceCount != 0 || !info.isOpen) {
            return false;
        }
        info.index.deactivate();
        this.memoryUsed -= info.index.getMemoryAllocationSize();
        info.isOpen = false;
        return true;
    }

    @Override
    public IIndex getIndex(long resourceID) {
        IndexInfo info = this.indexInfos.get(resourceID);
        return info == null ? null : info.index;
    }

    @Override
    public void register(long resourceID, IIndex index) throws HyracksDataException {
        if (this.indexInfos.containsKey(resourceID)) {
            throw new HyracksDataException("Index with resource ID " + resourceID + " already exists.");
        }
        this.indexInfos.put(resourceID, new IndexInfo(index));
    }

    @Override
    public void unregister(long resourceID) throws HyracksDataException {
        IndexInfo info = this.indexInfos.remove(resourceID);
        if (info == null) {
            throw new HyracksDataException("Index with resource ID " + resourceID + " does not exist.");
        }
        if (info.referenceCount != 0) {
            this.indexInfos.put(resourceID, info);
            throw new HyracksDataException("Cannot remove index while it is open.");
        }
        if (info.isOpen) {
            info.index.deactivate();
            this.memoryUsed -= info.index.getMemoryAllocationSize();
        }
    }

    @Override
    public void open(long resourceID) throws HyracksDataException {
        IndexInfo info = this.indexInfos.get(resourceID);
        if (info == null) {
            throw new HyracksDataException("Failed to open index with resource ID " + resourceID + " since it does not exist.");
        }
        if (!info.isOpen) {
            long inMemorySize = info.index.getMemoryAllocationSize();
            while (this.memoryUsed + inMemorySize > this.memoryBudget) {
                if (this.evictCandidateIndex()) continue;
                throw new HyracksDataException("Cannot activate index since memory budget would be exceeded.");
            }
            info.index.activate();
            info.isOpen = true;
            this.memoryUsed += inMemorySize;
        }
        info.touch();
    }

    @Override
    public void close(long resourceID) {
        this.indexInfos.get(resourceID).untouch();
    }

    @Override
    public List<IIndex> getOpenIndexes() {
        ArrayList<IIndex> openIndexes = new ArrayList<IIndex>();
        for (IndexInfo i : this.indexInfos.values()) {
            if (!i.isOpen) continue;
            openIndexes.add(i.index);
        }
        return openIndexes;
    }

    public void start() {
    }

    public void stop(boolean dumpState, OutputStream outputStream) throws IOException {
        if (dumpState) {
            this.dumpState(outputStream);
        }
        for (IndexInfo i : this.indexInfos.values()) {
            if (!i.isOpen) continue;
            i.index.deactivate();
        }
    }

    public void dumpState(OutputStream os) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Memory budget = %d\n", this.memoryBudget));
        sb.append(String.format("Memory used = %d\n", this.memoryUsed));
        String headerFormat = "%-20s %-10s %-20s %-20s %-20s\n";
        String rowFormat = "%-20d %-10b %-20d %-20s %-20s\n";
        sb.append(String.format(headerFormat, "ResourceID", "Open", "Reference Count", "Last Access", "Index Name"));
        for (Map.Entry<Long, IndexInfo> entry : this.indexInfos.entrySet()) {
            IndexInfo ii = entry.getValue();
            sb.append(String.format(rowFormat, entry.getKey(), ii.isOpen, ii.referenceCount, ii.lastAccess, ii.index));
        }
        os.write(sb.toString().getBytes());
    }

    private class IndexInfo
    implements Comparable<IndexInfo> {
        private final IIndex index;
        private int referenceCount;
        private long lastAccess;
        private boolean isOpen;

        public IndexInfo(IIndex index) {
            this.index = index;
            this.lastAccess = -1L;
            this.referenceCount = 0;
            this.isOpen = false;
        }

        public void touch() {
            this.lastAccess = System.currentTimeMillis();
            ++this.referenceCount;
        }

        public void untouch() {
            this.lastAccess = System.currentTimeMillis();
            --this.referenceCount;
        }

        @Override
        public int compareTo(IndexInfo i) {
            if (this.isOpen && !i.isOpen) {
                return -1;
            }
            if (!this.isOpen && i.isOpen) {
                return 1;
            }
            if (this.referenceCount < i.referenceCount) {
                return -1;
            }
            if (this.referenceCount > i.referenceCount) {
                return 1;
            }
            if (this.lastAccess < i.lastAccess) {
                return -1;
            }
            if (this.lastAccess > i.lastAccess) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "{index: " + this.index + ", isOpen: " + this.isOpen + ", refCount: " + this.referenceCount + ", lastAccess: " + this.lastAccess + "}";
        }
    }
}

